/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a <code>DescribeStream</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamRequest extends DynamoDbStreamsRequest implements
        ToCopyableBuilder<DescribeStreamRequest.Builder, DescribeStreamRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStreamRequest::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeStreamRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeStreamRequest::exclusiveStartShardId)).setter(setter(Builder::exclusiveStartShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD, LIMIT_FIELD,
            EXCLUSIVE_START_SHARD_ID_FIELD));

    private final String streamArn;

    private final Integer limit;

    private final String exclusiveStartShardId;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamArn = builder.streamArn;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the stream.
     */
    public String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The maximum number of shard objects to return. The upper limit is 100.
     * </p>
     * 
     * @return The maximum number of shard objects to return. The upper limit is 100.
     */
    public Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The shard ID of the first item that this operation will evaluate. Use the value that was returned for
     * <code>LastEvaluatedShardId</code> in the previous operation.
     * </p>
     * 
     * @return The shard ID of the first item that this operation will evaluate. Use the value that was returned for
     *         <code>LastEvaluatedShardId</code> in the previous operation.
     */
    public String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartShardId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest) obj;
        return Objects.equals(streamArn(), other.streamArn()) && Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartShardId(), other.exclusiveStartShardId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStreamRequest").add("StreamArn", streamArn()).add("Limit", limit())
                .add("ExclusiveStartShardId", exclusiveStartShardId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "ExclusiveStartShardId":
            return Optional.ofNullable(clazz.cast(exclusiveStartShardId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamRequest, T> g) {
        return obj -> g.apply((DescribeStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbStreamsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the stream.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The maximum number of shard objects to return. The upper limit is 100.
         * </p>
         * 
         * @param limit
         *        The maximum number of shard objects to return. The upper limit is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The shard ID of the first item that this operation will evaluate. Use the value that was returned for
         * <code>LastEvaluatedShardId</code> in the previous operation.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        The shard ID of the first item that this operation will evaluate. Use the value that was returned for
         *        <code>LastEvaluatedShardId</code> in the previous operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbStreamsRequest.BuilderImpl implements Builder {
        private String streamArn;

        private Integer limit;

        private String exclusiveStartShardId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            super(model);
            streamArn(model.streamArn);
            limit(model.limit);
            exclusiveStartShardId(model.exclusiveStartShardId);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        public final Integer getLimit() {
            return limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
