/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.paginators.DescribeStreamIterable;
import software.amazon.awssdk.services.dynamodb.streams.paginators.ListStreamsIterable;

public interface DynamoDbStreamsClient
extends SdkClient {
    public static final String SERVICE_NAME = "dynamodb";

    public static DynamoDbStreamsClient create() {
        return (DynamoDbStreamsClient)DynamoDbStreamsClient.builder().build();
    }

    public static DynamoDbStreamsClientBuilder builder() {
        return new DefaultDynamoDbStreamsClientBuilder();
    }

    default public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.describeStream((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().applyMutation(describeStreamRequest)).build()));
    }

    default public DescribeStreamIterable describeStreamPaginator(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamIterable describeStreamPaginator(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.describeStreamPaginator((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().applyMutation(describeStreamRequest)).build()));
    }

    default public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().applyMutation(getRecordsRequest)).build()));
    }

    default public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().applyMutation(getShardIteratorRequest)).build()));
    }

    default public ListStreamsResponse listStreams() throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.listStreams((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    default public ListStreamsIterable listStreamsPaginator() throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.listStreamsPaginator((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsIterable listStreamsPaginator(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsIterable listStreamsPaginator(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException, DynamoDbException {
        return this.listStreamsPaginator((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().applyMutation(listStreamsRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"streams.dynamodb");
    }
}

