/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactGetItemsRequest extends DynamoDbRequest implements
        ToCopyableBuilder<TransactGetItemsRequest.Builder, TransactGetItemsRequest> {
    private static final SdkField<List<TransactGetItem>> TRANSACT_ITEMS_FIELD = SdkField
            .<List<TransactGetItem>> builder(MarshallingType.LIST)
            .getter(getter(TransactGetItemsRequest::transactItems))
            .setter(setter(Builder::transactItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransactGetItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransactGetItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TransactGetItemsRequest::returnConsumedCapacityAsString))
            .setter(setter(Builder::returnConsumedCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACT_ITEMS_FIELD,
            RETURN_CONSUMED_CAPACITY_FIELD));

    private final List<TransactGetItem> transactItems;

    private final String returnConsumedCapacity;

    private TransactGetItemsRequest(BuilderImpl builder) {
        super(builder);
        this.transactItems = builder.transactItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    /**
     * <p>
     * An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code>
     * structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a
     *         <code>Get</code> structure.
     */
    public List<TransactGetItem> transactItems() {
        return transactItems;
    }

    /**
     * <p>
     * A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
     * <code>NONE</code> prevents that information from being returned. No other value is valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
     *         <code>NONE</code> prevents that information from being returned. No other value is valid.
     * @see ReturnConsumedCapacity
     */
    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(returnConsumedCapacity);
    }

    /**
     * <p>
     * A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
     * <code>NONE</code> prevents that information from being returned. No other value is valid.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #returnConsumedCapacity} will return {@link ReturnConsumedCapacity#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #returnConsumedCapacityAsString}.
     * </p>
     * 
     * @return A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
     *         <code>NONE</code> prevents that information from being returned. No other value is valid.
     * @see ReturnConsumedCapacity
     */
    public String returnConsumedCapacityAsString() {
        return returnConsumedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactItems());
        hashCode = 31 * hashCode + Objects.hashCode(returnConsumedCapacityAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactGetItemsRequest)) {
            return false;
        }
        TransactGetItemsRequest other = (TransactGetItemsRequest) obj;
        return Objects.equals(transactItems(), other.transactItems())
                && Objects.equals(returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TransactGetItemsRequest").add("TransactItems", transactItems())
                .add("ReturnConsumedCapacity", returnConsumedCapacityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactItems":
            return Optional.ofNullable(clazz.cast(transactItems()));
        case "ReturnConsumedCapacity":
            return Optional.ofNullable(clazz.cast(returnConsumedCapacityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactGetItemsRequest, T> g) {
        return obj -> g.apply((TransactGetItemsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, TransactGetItemsRequest> {
        /**
         * <p>
         * An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code>
         * structure.
         * </p>
         * 
         * @param transactItems
         *        An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a
         *        <code>Get</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactItems(Collection<TransactGetItem> transactItems);

        /**
         * <p>
         * An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code>
         * structure.
         * </p>
         * 
         * @param transactItems
         *        An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a
         *        <code>Get</code> structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactItems(TransactGetItem... transactItems);

        /**
         * <p>
         * An ordered array of up to 25 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code>
         * structure.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TransactGetItem>.Builder} avoiding the need
         * to create one manually via {@link List<TransactGetItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TransactGetItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #transactItems(List<TransactGetItem>)}.
         * 
         * @param transactItems
         *        a consumer that will call methods on {@link List<TransactGetItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactItems(List<TransactGetItem>)
         */
        Builder transactItems(Consumer<TransactGetItem.Builder>... transactItems);

        /**
         * <p>
         * A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
         * <code>NONE</code> prevents that information from being returned. No other value is valid.
         * </p>
         * 
         * @param returnConsumedCapacity
         *        A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
         *        <code>NONE</code> prevents that information from being returned. No other value is valid.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(String returnConsumedCapacity);

        /**
         * <p>
         * A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
         * <code>NONE</code> prevents that information from being returned. No other value is valid.
         * </p>
         * 
         * @param returnConsumedCapacity
         *        A value of <code>TOTAL</code> causes consumed capacity information to be returned, and a value of
         *        <code>NONE</code> prevents that information from being returned. No other value is valid.
         * @see ReturnConsumedCapacity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReturnConsumedCapacity
         */
        Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private List<TransactGetItem> transactItems = DefaultSdkAutoConstructList.getInstance();

        private String returnConsumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactGetItemsRequest model) {
            super(model);
            transactItems(model.transactItems);
            returnConsumedCapacity(model.returnConsumedCapacity);
        }

        public final Collection<TransactGetItem.Builder> getTransactItems() {
            return transactItems != null ? transactItems.stream().map(TransactGetItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder transactItems(Collection<TransactGetItem> transactItems) {
            this.transactItems = TransactGetItemListCopier.copy(transactItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(TransactGetItem... transactItems) {
            transactItems(Arrays.asList(transactItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactItems(Consumer<TransactGetItem.Builder>... transactItems) {
            transactItems(Stream.of(transactItems).map(c -> TransactGetItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTransactItems(Collection<TransactGetItem.BuilderImpl> transactItems) {
            this.transactItems = TransactGetItemListCopier.copyFromBuilder(transactItems);
        }

        public final String getReturnConsumedCapacityAsString() {
            return returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TransactGetItemsRequest build() {
            return new TransactGetItemsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
