/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data for an attribute.
 * </p>
 * <p>
 * Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.
 * </p>
 * <p>
 * For more information, see <a href=
 * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes"
 * >Data Types</a> in the <i>Amazon DynamoDB Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeValue implements SdkPojo, Serializable, ToCopyableBuilder<AttributeValue.Builder, AttributeValue> {
    private static final SdkField<String> S_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttributeValue::s)).setter(setter(Builder::s))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S").build()).build();

    private static final SdkField<String> N_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttributeValue::n)).setter(setter(Builder::n))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("N").build()).build();

    private static final SdkField<SdkBytes> B_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(AttributeValue::b)).setter(setter(Builder::b))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("B").build()).build();

    private static final SdkField<List<String>> SS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AttributeValue::ss))
            .setter(setter(Builder::ss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AttributeValue::ns))
            .setter(setter(Builder::ns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SdkBytes>> BS_FIELD = SdkField
            .<List<SdkBytes>> builder(MarshallingType.LIST)
            .getter(getter(AttributeValue::bs))
            .setter(setter(Builder::bs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BS").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, AttributeValue>> M_FIELD = SdkField
            .<Map<String, AttributeValue>> builder(MarshallingType.MAP)
            .getter(getter(AttributeValue::m))
            .setter(setter(Builder::m))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("M").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AttributeValue>> L_FIELD = SdkField
            .<List<AttributeValue>> builder(MarshallingType.LIST)
            .getter(getter(AttributeValue::l))
            .setter(setter(Builder::l))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("L").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> BOOL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AttributeValue::bool)).setter(setter(Builder::bool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BOOL").build()).build();

    private static final SdkField<Boolean> NUL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AttributeValue::nul)).setter(setter(Builder::nul))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NULL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S_FIELD, N_FIELD, B_FIELD,
            SS_FIELD, NS_FIELD, BS_FIELD, M_FIELD, L_FIELD, BOOL_FIELD, NUL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s;

    private final String n;

    private final SdkBytes b;

    private final List<String> ss;

    private final List<String> ns;

    private final List<SdkBytes> bs;

    private final Map<String, AttributeValue> m;

    private final List<AttributeValue> l;

    private final Boolean bool;

    private final Boolean nul;

    private AttributeValue(BuilderImpl builder) {
        this.s = builder.s;
        this.n = builder.n;
        this.b = builder.b;
        this.ss = builder.ss;
        this.ns = builder.ns;
        this.bs = builder.bs;
        this.m = builder.m;
        this.l = builder.l;
        this.bool = builder.bool;
        this.nul = builder.nul;
    }

    /**
     * <p>
     * An attribute of type String. For example:
     * </p>
     * <p>
     * <code>"S": "Hello"</code>
     * </p>
     * 
     * @return An attribute of type String. For example:</p>
     *         <p>
     *         <code>"S": "Hello"</code>
     */
    public String s() {
        return s;
    }

    /**
     * <p>
     * An attribute of type Number. For example:
     * </p>
     * <p>
     * <code>"N": "123.45"</code>
     * </p>
     * <p>
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
     * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     * </p>
     * 
     * @return An attribute of type Number. For example:</p>
     *         <p>
     *         <code>"N": "123.45"</code>
     *         </p>
     *         <p>
     *         Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
     *         and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public String n() {
        return n;
    }

    /**
     * <p>
     * An attribute of type Binary. For example:
     * </p>
     * <p>
     * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     * </p>
     * 
     * @return An attribute of type Binary. For example:</p>
     *         <p>
     *         <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
     */
    public SdkBytes b() {
        return b;
    }

    /**
     * <p>
     * An attribute of type String Set. For example:
     * </p>
     * <p>
     * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An attribute of type String Set. For example:</p>
     *         <p>
     *         <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
     */
    public List<String> ss() {
        return ss;
    }

    /**
     * <p>
     * An attribute of type Number Set. For example:
     * </p>
     * <p>
     * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
     * </p>
     * <p>
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
     * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An attribute of type Number Set. For example:</p>
     *         <p>
     *         <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
     *         </p>
     *         <p>
     *         Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
     *         and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public List<String> ns() {
        return ns;
    }

    /**
     * <p>
     * An attribute of type Binary Set. For example:
     * </p>
     * <p>
     * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An attribute of type Binary Set. For example:</p>
     *         <p>
     *         <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
     */
    public List<SdkBytes> bs() {
        return bs;
    }

    /**
     * <p>
     * An attribute of type Map. For example:
     * </p>
     * <p>
     * <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An attribute of type Map. For example:</p>
     *         <p>
     *         <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
     */
    public Map<String, AttributeValue> m() {
        return m;
    }

    /**
     * <p>
     * An attribute of type List. For example:
     * </p>
     * <p>
     * <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An attribute of type List. For example:</p>
     *         <p>
     *         <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
     */
    public List<AttributeValue> l() {
        return l;
    }

    /**
     * <p>
     * An attribute of type Boolean. For example:
     * </p>
     * <p>
     * <code>"BOOL": true</code>
     * </p>
     * 
     * @return An attribute of type Boolean. For example:</p>
     *         <p>
     *         <code>"BOOL": true</code>
     */
    public Boolean bool() {
        return bool;
    }

    /**
     * <p>
     * An attribute of type Null. For example:
     * </p>
     * <p>
     * <code>"NULL": true</code>
     * </p>
     * 
     * @return An attribute of type Null. For example:</p>
     *         <p>
     *         <code>"NULL": true</code>
     */
    public Boolean nul() {
        return nul;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s());
        hashCode = 31 * hashCode + Objects.hashCode(n());
        hashCode = 31 * hashCode + Objects.hashCode(b());
        hashCode = 31 * hashCode + Objects.hashCode(ss());
        hashCode = 31 * hashCode + Objects.hashCode(ns());
        hashCode = 31 * hashCode + Objects.hashCode(bs());
        hashCode = 31 * hashCode + Objects.hashCode(m());
        hashCode = 31 * hashCode + Objects.hashCode(l());
        hashCode = 31 * hashCode + Objects.hashCode(bool());
        hashCode = 31 * hashCode + Objects.hashCode(nul());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeValue)) {
            return false;
        }
        AttributeValue other = (AttributeValue) obj;
        return Objects.equals(s(), other.s()) && Objects.equals(n(), other.n()) && Objects.equals(b(), other.b())
                && Objects.equals(ss(), other.ss()) && Objects.equals(ns(), other.ns()) && Objects.equals(bs(), other.bs())
                && Objects.equals(m(), other.m()) && Objects.equals(l(), other.l()) && Objects.equals(bool(), other.bool())
                && Objects.equals(nul(), other.nul());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttributeValue").add("S", s()).add("N", n()).add("B", b()).add("SS", ss()).add("NS", ns())
                .add("BS", bs()).add("M", m()).add("L", l()).add("BOOL", bool()).add("NUL", nul()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S":
            return Optional.ofNullable(clazz.cast(s()));
        case "N":
            return Optional.ofNullable(clazz.cast(n()));
        case "B":
            return Optional.ofNullable(clazz.cast(b()));
        case "SS":
            return Optional.ofNullable(clazz.cast(ss()));
        case "NS":
            return Optional.ofNullable(clazz.cast(ns()));
        case "BS":
            return Optional.ofNullable(clazz.cast(bs()));
        case "M":
            return Optional.ofNullable(clazz.cast(m()));
        case "L":
            return Optional.ofNullable(clazz.cast(l()));
        case "BOOL":
            return Optional.ofNullable(clazz.cast(bool()));
        case "NUL":
            return Optional.ofNullable(clazz.cast(nul()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeValue, T> g) {
        return obj -> g.apply((AttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeValue> {
        /**
         * <p>
         * An attribute of type String. For example:
         * </p>
         * <p>
         * <code>"S": "Hello"</code>
         * </p>
         * 
         * @param s
         *        An attribute of type String. For example:</p>
         *        <p>
         *        <code>"S": "Hello"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s(String s);

        /**
         * <p>
         * An attribute of type Number. For example:
         * </p>
         * <p>
         * <code>"N": "123.45"</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * 
         * @param n
         *        An attribute of type Number. For example:</p>
         *        <p>
         *        <code>"N": "123.45"</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder n(String n);

        /**
         * <p>
         * An attribute of type Binary. For example:
         * </p>
         * <p>
         * <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * </p>
         * 
         * @param b
         *        An attribute of type Binary. For example:</p>
         *        <p>
         *        <code>"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder b(SdkBytes b);

        /**
         * <p>
         * An attribute of type String Set. For example:
         * </p>
         * <p>
         * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * </p>
         * 
         * @param ss
         *        An attribute of type String Set. For example:</p>
         *        <p>
         *        <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(Collection<String> ss);

        /**
         * <p>
         * An attribute of type String Set. For example:
         * </p>
         * <p>
         * <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * </p>
         * 
         * @param ss
         *        An attribute of type String Set. For example:</p>
         *        <p>
         *        <code>"SS": ["Giraffe", "Hippo" ,"Zebra"]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ss(String... ss);

        /**
         * <p>
         * An attribute of type Number Set. For example:
         * </p>
         * <p>
         * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * 
         * @param ns
         *        An attribute of type Number Set. For example:</p>
         *        <p>
         *        <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(Collection<String> ns);

        /**
         * <p>
         * An attribute of type Number Set. For example:
         * </p>
         * <p>
         * <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         * </p>
         * <p>
         * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and
         * libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * </p>
         * 
         * @param ns
         *        An attribute of type Number Set. For example:</p>
         *        <p>
         *        <code>"NS": ["42.2", "-19", "7.5", "3.14"]</code>
         *        </p>
         *        <p>
         *        Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages
         *        and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ns(String... ns);

        /**
         * <p>
         * An attribute of type Binary Set. For example:
         * </p>
         * <p>
         * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * </p>
         * 
         * @param bs
         *        An attribute of type Binary Set. For example:</p>
         *        <p>
         *        <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(Collection<SdkBytes> bs);

        /**
         * <p>
         * An attribute of type Binary Set. For example:
         * </p>
         * <p>
         * <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * </p>
         * 
         * @param bs
         *        An attribute of type Binary Set. For example:</p>
         *        <p>
         *        <code>"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bs(SdkBytes... bs);

        /**
         * <p>
         * An attribute of type Map. For example:
         * </p>
         * <p>
         * <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
         * </p>
         * 
         * @param m
         *        An attribute of type Map. For example:</p>
         *        <p>
         *        <code>"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m(Map<String, AttributeValue> m);

        /**
         * <p>
         * An attribute of type List. For example:
         * </p>
         * <p>
         * <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
         * </p>
         * 
         * @param l
         *        An attribute of type List. For example:</p>
         *        <p>
         *        <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l(Collection<AttributeValue> l);

        /**
         * <p>
         * An attribute of type List. For example:
         * </p>
         * <p>
         * <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
         * </p>
         * 
         * @param l
         *        An attribute of type List. For example:</p>
         *        <p>
         *        <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder l(AttributeValue... l);

        /**
         * <p>
         * An attribute of type List. For example:
         * </p>
         * <p>
         * <code>"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}]</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttributeValue>.Builder} avoiding the need
         * to create one manually via {@link List<AttributeValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttributeValue>.Builder#build()} is called immediately and
         * its result is passed to {@link #l(List<AttributeValue>)}.
         * 
         * @param l
         *        a consumer that will call methods on {@link List<AttributeValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #l(List<AttributeValue>)
         */
        Builder l(Consumer<Builder>... l);

        /**
         * <p>
         * An attribute of type Boolean. For example:
         * </p>
         * <p>
         * <code>"BOOL": true</code>
         * </p>
         * 
         * @param bool
         *        An attribute of type Boolean. For example:</p>
         *        <p>
         *        <code>"BOOL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bool(Boolean bool);

        /**
         * <p>
         * An attribute of type Null. For example:
         * </p>
         * <p>
         * <code>"NULL": true</code>
         * </p>
         * 
         * @param nul
         *        An attribute of type Null. For example:</p>
         *        <p>
         *        <code>"NULL": true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nul(Boolean nul);
    }

    static final class BuilderImpl implements Builder {
        private String s;

        private String n;

        private SdkBytes b;

        private List<String> ss = DefaultSdkAutoConstructList.getInstance();

        private List<String> ns = DefaultSdkAutoConstructList.getInstance();

        private List<SdkBytes> bs = DefaultSdkAutoConstructList.getInstance();

        private Map<String, AttributeValue> m = DefaultSdkAutoConstructMap.getInstance();

        private List<AttributeValue> l = DefaultSdkAutoConstructList.getInstance();

        private Boolean bool;

        private Boolean nul;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeValue model) {
            s(model.s);
            n(model.n);
            b(model.b);
            ss(model.ss);
            ns(model.ns);
            bs(model.bs);
            m(model.m);
            l(model.l);
            bool(model.bool);
            nul(model.nul);
        }

        public final String getS() {
            return s;
        }

        @Override
        public final Builder s(String s) {
            this.s = s;
            return this;
        }

        public final void setS(String s) {
            this.s = s;
        }

        public final String getN() {
            return n;
        }

        @Override
        public final Builder n(String n) {
            this.n = n;
            return this;
        }

        public final void setN(String n) {
            this.n = n;
        }

        public final ByteBuffer getB() {
            return b == null ? null : b.asByteBuffer();
        }

        @Override
        public final Builder b(SdkBytes b) {
            this.b = StandardMemberCopier.copy(b);
            return this;
        }

        public final void setB(ByteBuffer b) {
            b(b == null ? null : SdkBytes.fromByteBuffer(b));
        }

        public final Collection<String> getSs() {
            return ss;
        }

        @Override
        public final Builder ss(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ss(String... ss) {
            ss(Arrays.asList(ss));
            return this;
        }

        public final void setSs(Collection<String> ss) {
            this.ss = StringSetAttributeValueCopier.copy(ss);
        }

        public final Collection<String> getNs() {
            return ns;
        }

        @Override
        public final Builder ns(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ns(String... ns) {
            ns(Arrays.asList(ns));
            return this;
        }

        public final void setNs(Collection<String> ns) {
            this.ns = NumberSetAttributeValueCopier.copy(ns);
        }

        public final List<ByteBuffer> getBs() {
            return bs == null ? null : bs.stream().map(SdkBytes::asByteBuffer).collect(Collectors.toList());
        }

        @Override
        public final Builder bs(Collection<SdkBytes> bs) {
            this.bs = BinarySetAttributeValueCopier.copy(bs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bs(SdkBytes... bs) {
            bs(Arrays.asList(bs));
            return this;
        }

        public final void setBs(Collection<ByteBuffer> bs) {
            bs(bs == null ? null : bs.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        public final Map<String, Builder> getM() {
            return m != null ? CollectionUtils.mapValues(m, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder m(Map<String, AttributeValue> m) {
            this.m = MapAttributeValueCopier.copy(m);
            return this;
        }

        public final void setM(Map<String, BuilderImpl> m) {
            this.m = MapAttributeValueCopier.copyFromBuilder(m);
        }

        public final Collection<Builder> getL() {
            return l != null ? l.stream().map(AttributeValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder l(Collection<AttributeValue> l) {
            this.l = ListAttributeValueCopier.copy(l);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(AttributeValue... l) {
            l(Arrays.asList(l));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder l(Consumer<Builder>... l) {
            l(Stream.of(l).map(c -> AttributeValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setL(Collection<BuilderImpl> l) {
            this.l = ListAttributeValueCopier.copyFromBuilder(l);
        }

        public final Boolean getBool() {
            return bool;
        }

        @Override
        public final Builder bool(Boolean bool) {
            this.bool = bool;
            return this;
        }

        public final void setBool(Boolean bool) {
            this.bool = bool;
        }

        public final Boolean getNul() {
            return nul;
        }

        @Override
        public final Builder nul(Boolean nul) {
            this.nul = nul;
            return this;
        }

        public final void setNul(Boolean nul) {
            this.nul = nul;
        }

        @Override
        public AttributeValue build() {
            return new AttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
