/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of a <code>DescribeTable</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableResponse extends DynamoDbResponse implements
        ToCopyableBuilder<DescribeTableResponse.Builder, DescribeTableResponse> {
    private static final SdkField<TableDescription> TABLE_FIELD = SdkField.<TableDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeTableResponse::table)).setter(setter(Builder::table)).constructor(TableDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_FIELD));

    private final TableDescription table;

    private DescribeTableResponse(BuilderImpl builder) {
        super(builder);
        this.table = builder.table;
    }

    /**
     * <p>
     * The properties of the table.
     * </p>
     * 
     * @return The properties of the table.
     */
    public TableDescription table() {
        return table;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(table());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableResponse)) {
            return false;
        }
        DescribeTableResponse other = (DescribeTableResponse) obj;
        return Objects.equals(table(), other.table());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTableResponse").add("Table", table()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableResponse, T> g) {
        return obj -> g.apply((DescribeTableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTableResponse> {
        /**
         * <p>
         * The properties of the table.
         * </p>
         * 
         * @param table
         *        The properties of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(TableDescription table);

        /**
         * <p>
         * The properties of the table.
         * </p>
         * This is a convenience that creates an instance of the {@link TableDescription.Builder} avoiding the need to
         * create one manually via {@link TableDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link TableDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #table(TableDescription)}.
         * 
         * @param table
         *        a consumer that will call methods on {@link TableDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #table(TableDescription)
         */
        default Builder table(Consumer<TableDescription.Builder> table) {
            return table(TableDescription.builder().applyMutation(table).build());
        }
    }

    static final class BuilderImpl extends DynamoDbResponse.BuilderImpl implements Builder {
        private TableDescription table;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableResponse model) {
            super(model);
            table(model.table);
        }

        public final TableDescription.Builder getTable() {
            return table != null ? table.toBuilder() : null;
        }

        @Override
        public final Builder table(TableDescription table) {
            this.table = table;
            return this;
        }

        public final void setTable(TableDescription.BuilderImpl table) {
            this.table = table != null ? table.build() : null;
        }

        @Override
        public DescribeTableResponse build() {
            return new DescribeTableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
