/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChangedBlocksResponse extends EbsResponse implements
        ToCopyableBuilder<ListChangedBlocksResponse.Builder, ListChangedBlocksResponse> {
    private static final SdkField<List<ChangedBlock>> CHANGED_BLOCKS_FIELD = SdkField
            .<List<ChangedBlock>> builder(MarshallingType.LIST)
            .memberName("ChangedBlocks")
            .getter(getter(ListChangedBlocksResponse::changedBlocks))
            .setter(setter(Builder::changedBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangedBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangedBlock> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangedBlock::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> EXPIRY_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryTime").getter(getter(ListChangedBlocksResponse::expiryTime)).setter(setter(Builder::expiryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryTime").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeSize").getter(getter(ListChangedBlocksResponse::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<Integer> BLOCK_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockSize").getter(getter(ListChangedBlocksResponse::blockSize)).setter(setter(Builder::blockSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockSize").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListChangedBlocksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGED_BLOCKS_FIELD,
            EXPIRY_TIME_FIELD, VOLUME_SIZE_FIELD, BLOCK_SIZE_FIELD, NEXT_TOKEN_FIELD));

    private final List<ChangedBlock> changedBlocks;

    private final Instant expiryTime;

    private final Long volumeSize;

    private final Integer blockSize;

    private final String nextToken;

    private ListChangedBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.changedBlocks = builder.changedBlocks;
        this.expiryTime = builder.expiryTime;
        this.volumeSize = builder.volumeSize;
        this.blockSize = builder.blockSize;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ChangedBlocks property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasChangedBlocks() {
        return changedBlocks != null && !(changedBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects containing information about the changed blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChangedBlocks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of objects containing information about the changed blocks.
     */
    public final List<ChangedBlock> changedBlocks() {
        return changedBlocks;
    }

    /**
     * <p>
     * The time when the <code>BlockToken</code> expires.
     * </p>
     * 
     * @return The time when the <code>BlockToken</code> expires.
     */
    public final Instant expiryTime() {
        return expiryTime;
    }

    /**
     * <p>
     * The size of the volume in GB.
     * </p>
     * 
     * @return The size of the volume in GB.
     */
    public final Long volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The size of the block.
     * </p>
     * 
     * @return The size of the block.
     */
    public final Integer blockSize() {
        return blockSize;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChangedBlocks() ? changedBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expiryTime());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(blockSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangedBlocksResponse)) {
            return false;
        }
        ListChangedBlocksResponse other = (ListChangedBlocksResponse) obj;
        return hasChangedBlocks() == other.hasChangedBlocks() && Objects.equals(changedBlocks(), other.changedBlocks())
                && Objects.equals(expiryTime(), other.expiryTime()) && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(blockSize(), other.blockSize()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChangedBlocksResponse")
                .add("ChangedBlocks", changedBlocks() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExpiryTime", expiryTime()).add("VolumeSize", volumeSize()).add("BlockSize", blockSize())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangedBlocks":
            return Optional.ofNullable(clazz.cast(changedBlocks()));
        case "ExpiryTime":
            return Optional.ofNullable(clazz.cast(expiryTime()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "BlockSize":
            return Optional.ofNullable(clazz.cast(blockSize()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChangedBlocksResponse, T> g) {
        return obj -> g.apply((ListChangedBlocksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListChangedBlocksResponse> {
        /**
         * <p>
         * An array of objects containing information about the changed blocks.
         * </p>
         * 
         * @param changedBlocks
         *        An array of objects containing information about the changed blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changedBlocks(Collection<ChangedBlock> changedBlocks);

        /**
         * <p>
         * An array of objects containing information about the changed blocks.
         * </p>
         * 
         * @param changedBlocks
         *        An array of objects containing information about the changed blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changedBlocks(ChangedBlock... changedBlocks);

        /**
         * <p>
         * An array of objects containing information about the changed blocks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ChangedBlock>.Builder} avoiding the need to
         * create one manually via {@link List<ChangedBlock>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChangedBlock>.Builder#build()} is called immediately and its
         * result is passed to {@link #changedBlocks(List<ChangedBlock>)}.
         * 
         * @param changedBlocks
         *        a consumer that will call methods on {@link List<ChangedBlock>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changedBlocks(List<ChangedBlock>)
         */
        Builder changedBlocks(Consumer<ChangedBlock.Builder>... changedBlocks);

        /**
         * <p>
         * The time when the <code>BlockToken</code> expires.
         * </p>
         * 
         * @param expiryTime
         *        The time when the <code>BlockToken</code> expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryTime(Instant expiryTime);

        /**
         * <p>
         * The size of the volume in GB.
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Long volumeSize);

        /**
         * <p>
         * The size of the block.
         * </p>
         * 
         * @param blockSize
         *        The size of the block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockSize(Integer blockSize);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EbsResponse.BuilderImpl implements Builder {
        private List<ChangedBlock> changedBlocks = DefaultSdkAutoConstructList.getInstance();

        private Instant expiryTime;

        private Long volumeSize;

        private Integer blockSize;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangedBlocksResponse model) {
            super(model);
            changedBlocks(model.changedBlocks);
            expiryTime(model.expiryTime);
            volumeSize(model.volumeSize);
            blockSize(model.blockSize);
            nextToken(model.nextToken);
        }

        public final List<ChangedBlock.Builder> getChangedBlocks() {
            List<ChangedBlock.Builder> result = ChangedBlocksCopier.copyToBuilder(this.changedBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder changedBlocks(Collection<ChangedBlock> changedBlocks) {
            this.changedBlocks = ChangedBlocksCopier.copy(changedBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changedBlocks(ChangedBlock... changedBlocks) {
            changedBlocks(Arrays.asList(changedBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changedBlocks(Consumer<ChangedBlock.Builder>... changedBlocks) {
            changedBlocks(Stream.of(changedBlocks).map(c -> ChangedBlock.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChangedBlocks(Collection<ChangedBlock.BuilderImpl> changedBlocks) {
            this.changedBlocks = ChangedBlocksCopier.copyFromBuilder(changedBlocks);
        }

        public final Instant getExpiryTime() {
            return expiryTime;
        }

        @Override
        public final Builder expiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public final void setExpiryTime(Instant expiryTime) {
            this.expiryTime = expiryTime;
        }

        public final Long getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final Integer getBlockSize() {
            return blockSize;
        }

        @Override
        public final Builder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public final void setBlockSize(Integer blockSize) {
            this.blockSize = blockSize;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChangedBlocksResponse build() {
            return new ListChangedBlocksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
