/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSnapshotRequest extends EbsRequest implements
        ToCopyableBuilder<StartSnapshotRequest.Builder, StartSnapshotRequest> {
    private static final SdkField<Long> VOLUME_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeSize").getter(getter(StartSnapshotRequest::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> PARENT_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentSnapshotId").getter(getter(StartSnapshotRequest::parentSnapshotId))
            .setter(setter(Builder::parentSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentSnapshotId").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartSnapshotRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartSnapshotRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(StartSnapshotRequest::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(StartSnapshotRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(StartSnapshotRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SIZE_FIELD,
            PARENT_SNAPSHOT_ID_FIELD, TAGS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ARN_FIELD,
            TIMEOUT_FIELD));

    private final Long volumeSize;

    private final String parentSnapshotId;

    private final List<Tag> tags;

    private final String description;

    private final String clientToken;

    private final Boolean encrypted;

    private final String kmsKeyArn;

    private final Integer timeout;

    private StartSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.volumeSize = builder.volumeSize;
        this.parentSnapshotId = builder.parentSnapshotId;
        this.tags = builder.tags;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.encrypted = builder.encrypted;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.timeout = builder.timeout;
    }

    /**
     * <p>
     * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     * </p>
     * 
     * @return The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
     */
    public final Long volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for an
     * on-premises volume, omit this parameter.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     * snapshot. You must first create an encrypted copy of the parent snapshot using <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     * </p>
     * 
     * @return The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot
     *         for an on-premises volume, omit this parameter.</p>
     *         <p>
     *         If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
     *         snapshot. You must first create an encrypted copy of the parent snapshot using <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
     */
    public final String parentSnapshotId() {
        return parentSnapshotId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to apply to the snapshot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the snapshot.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A description for the snapshot.
     * </p>
     * 
     * @return A description for the snapshot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully. The subsequent retries with the same client token return the result from the original successful
     * request and they have no additional effect.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
     * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully. The subsequent retries with the same client token return the result from
     *         the original successful request and they have no additional effect.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency
     *         for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To create
     * an unencrypted snapshot, omit this parameter.
     * </p>
     * <p>
     * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     * </p>
     * <p>
     * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your account
     * is used. If no default KMS key has been specified for your account, the Amazon Web Services managed KMS key is
     * used. To set a default KMS key for your account, use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     * ModifyEbsDefaultKmsKeyId</a>.
     * </p>
     * <p>
     * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
     * this case, you can omit this parameter.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
     * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
     *         create an unencrypted snapshot, omit this parameter.</p>
     *         <p>
     *         If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
     *         </p>
     *         <p>
     *         If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
     *         <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
     *         account is used. If no default KMS key has been specified for your account, the Amazon Web Services
     *         managed KMS key is used. To set a default KMS key for your account, use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
     *         ModifyEbsDefaultKmsKeyId</a>.
     *         </p>
     *         <p>
     *         If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>
     *         . In this case, you can omit this parameter.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
     *         > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If you
     * do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
     * </p>
     * <p>
     * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same KMS
     * key that was used to encrypt the parent snapshot.
     * </p>
     * <p>
     * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the
     *         snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.</p>
     *         <p>
     *         If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the
     *         same KMS key that was used to encrypt the parent snapshot.
     *         </p>
     *         <p>
     *         If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
     * </p>
     * <ul>
     * <li>
     * <p>
     * No blocks are written to the snapshot.
     * </p>
     * </li>
     * <li>
     * <p>
     * The snapshot is not completed after writing the last block of data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If no value is specified, the timeout defaults to <code>60</code> minutes.
     * </p>
     * 
     * @return The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No blocks are written to the snapshot.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The snapshot is not completed after writing the last block of data.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If no value is specified, the timeout defaults to <code>60</code> minutes.
     */
    public final Integer timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(parentSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSnapshotRequest)) {
            return false;
        }
        StartSnapshotRequest other = (StartSnapshotRequest) obj;
        return Objects.equals(volumeSize(), other.volumeSize()) && Objects.equals(parentSnapshotId(), other.parentSnapshotId())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(encrypted(), other.encrypted()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSnapshotRequest").add("VolumeSize", volumeSize())
                .add("ParentSnapshotId", parentSnapshotId()).add("Tags", hasTags() ? tags() : null)
                .add("Description", description()).add("ClientToken", clientToken()).add("Encrypted", encrypted())
                .add("KmsKeyArn", kmsKeyArn() == null ? null : "*** Sensitive Data Redacted ***").add("Timeout", timeout())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "ParentSnapshotId":
            return Optional.ofNullable(clazz.cast(parentSnapshotId()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSnapshotRequest, T> g) {
        return obj -> g.apply((StartSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSnapshotRequest> {
        /**
         * <p>
         * The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
         * </p>
         * 
         * @param volumeSize
         *        The size of the volume, in GiB. The maximum size is <code>65536</code> GiB (64 TiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Long volumeSize);

        /**
         * <p>
         * The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first snapshot for
         * an on-premises volume, omit this parameter.
         * </p>
         * <p>
         * If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a parent
         * snapshot. You must first create an encrypted copy of the parent snapshot using <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
         * </p>
         * 
         * @param parentSnapshotId
         *        The ID of the parent snapshot. If there is no parent snapshot, or if you are creating the first
         *        snapshot for an on-premises volume, omit this parameter.</p>
         *        <p>
         *        If your account is enabled for encryption by default, you cannot use an unencrypted snapshot as a
         *        parent snapshot. You must first create an encrypted copy of the parent snapshot using <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html">CopySnapshot</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentSnapshotId(String parentSnapshotId);

        /**
         * <p>
         * The tags to apply to the snapshot.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to apply to the snapshot.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to apply to the snapshot.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A description for the snapshot.
         * </p>
         * 
         * @param description
         *        A description for the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully. The subsequent retries with the same client token return the result from the original
         * successful request and they have no additional effect.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html"> Idempotency for
         * StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully. The subsequent retries with the same client token return the
         *        result from the original successful request and they have no additional effect.</p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html">
         *        Idempotency for StartSnapshot API</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>. To
         * create an unencrypted snapshot, omit this parameter.
         * </p>
         * <p>
         * If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
         * </p>
         * <p>
         * If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
         * <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for your
         * account is used. If no default KMS key has been specified for your account, the Amazon Web Services managed
         * KMS key is used. To set a default KMS key for your account, use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
         * ModifyEbsDefaultKmsKeyId</a>.
         * </p>
         * <p>
         * If your account is enabled for encryption by default, you cannot set this parameter to <code>false</code>. In
         * this case, you can omit this parameter.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption">
         * Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Indicates whether to encrypt the snapshot. To create an encrypted snapshot, specify <code>true</code>.
         *        To create an unencrypted snapshot, omit this parameter.</p>
         *        <p>
         *        If you specify a value for <b>ParentSnapshotId</b>, omit this parameter.
         *        </p>
         *        <p>
         *        If you specify <code>true</code>, the snapshot is encrypted using the KMS key specified using the
         *        <b>KmsKeyArn</b> parameter. If no value is specified for <b>KmsKeyArn</b>, the default KMS key for
         *        your account is used. If no default KMS key has been specified for your account, the Amazon Web
         *        Services managed KMS key is used. To set a default KMS key for your account, use <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html">
         *        ModifyEbsDefaultKmsKeyId</a>.
         *        </p>
         *        <p>
         *        If your account is enabled for encryption by default, you cannot set this parameter to
         *        <code>false</code>. In this case, you can omit this parameter.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption"
         *        > Using encryption</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the snapshot. If
         * you do not specify a KMS key, the default Amazon Web Services managed KMS key is used.
         * </p>
         * <p>
         * If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using the same
         * KMS key that was used to encrypt the parent snapshot.
         * </p>
         * <p>
         * If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service (KMS) key to be used to encrypt the
         *        snapshot. If you do not specify a KMS key, the default Amazon Web Services managed KMS key is
         *        used.</p>
         *        <p>
         *        If you specify a <b>ParentSnapshotId</b>, omit this parameter; the snapshot will be encrypted using
         *        the same KMS key that was used to encrypt the parent snapshot.
         *        </p>
         *        <p>
         *        If <b>Encrypted</b> is set to <code>true</code>, you must specify a KMS key ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The amount of time (in minutes) after which the snapshot is automatically cancelled if:
         * </p>
         * <ul>
         * <li>
         * <p>
         * No blocks are written to the snapshot.
         * </p>
         * </li>
         * <li>
         * <p>
         * The snapshot is not completed after writing the last block of data.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If no value is specified, the timeout defaults to <code>60</code> minutes.
         * </p>
         * 
         * @param timeout
         *        The amount of time (in minutes) after which the snapshot is automatically cancelled if:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        No blocks are written to the snapshot.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The snapshot is not completed after writing the last block of data.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If no value is specified, the timeout defaults to <code>60</code> minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EbsRequest.BuilderImpl implements Builder {
        private Long volumeSize;

        private String parentSnapshotId;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String clientToken;

        private Boolean encrypted;

        private String kmsKeyArn;

        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSnapshotRequest model) {
            super(model);
            volumeSize(model.volumeSize);
            parentSnapshotId(model.parentSnapshotId);
            tags(model.tags);
            description(model.description);
            clientToken(model.clientToken);
            encrypted(model.encrypted);
            kmsKeyArn(model.kmsKeyArn);
            timeout(model.timeout);
        }

        public final Long getVolumeSize() {
            return volumeSize;
        }

        public final void setVolumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
        }

        @Override
        @Transient
        public final Builder volumeSize(Long volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final String getParentSnapshotId() {
            return parentSnapshotId;
        }

        public final void setParentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
        }

        @Override
        @Transient
        public final Builder parentSnapshotId(String parentSnapshotId) {
            this.parentSnapshotId = parentSnapshotId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        @Transient
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSnapshotRequest build() {
            return new StartSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
