/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block of data in an Amazon Elastic Block Store snapshot that is different from another snapshot of the same
 * volume/snapshot lineage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangedBlock implements SdkPojo, Serializable, ToCopyableBuilder<ChangedBlock.Builder, ChangedBlock> {
    private static final SdkField<Integer> BLOCK_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockIndex").getter(getter(ChangedBlock::blockIndex)).setter(setter(Builder::blockIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockIndex").build()).build();

    private static final SdkField<String> FIRST_BLOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstBlockToken").getter(getter(ChangedBlock::firstBlockToken)).setter(setter(Builder::firstBlockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstBlockToken").build()).build();

    private static final SdkField<String> SECOND_BLOCK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondBlockToken").getter(getter(ChangedBlock::secondBlockToken))
            .setter(setter(Builder::secondBlockToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondBlockToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_INDEX_FIELD,
            FIRST_BLOCK_TOKEN_FIELD, SECOND_BLOCK_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer blockIndex;

    private final String firstBlockToken;

    private final String secondBlockToken;

    private ChangedBlock(BuilderImpl builder) {
        this.blockIndex = builder.blockIndex;
        this.firstBlockToken = builder.firstBlockToken;
        this.secondBlockToken = builder.secondBlockToken;
    }

    /**
     * <p>
     * The block index.
     * </p>
     * 
     * @return The block index.
     */
    public final Integer blockIndex() {
        return blockIndex;
    }

    /**
     * <p>
     * The block token for the block index of the <code>FirstSnapshotId</code> specified in the
     * <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the changed
     * block that is on the second snapshot.
     * </p>
     * 
     * @return The block token for the block index of the <code>FirstSnapshotId</code> specified in the
     *         <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the
     *         changed block that is on the second snapshot.
     */
    public final String firstBlockToken() {
        return firstBlockToken;
    }

    /**
     * <p>
     * The block token for the block index of the <code>SecondSnapshotId</code> specified in the
     * <code>ListChangedBlocks</code> operation.
     * </p>
     * 
     * @return The block token for the block index of the <code>SecondSnapshotId</code> specified in the
     *         <code>ListChangedBlocks</code> operation.
     */
    public final String secondBlockToken() {
        return secondBlockToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockIndex());
        hashCode = 31 * hashCode + Objects.hashCode(firstBlockToken());
        hashCode = 31 * hashCode + Objects.hashCode(secondBlockToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangedBlock)) {
            return false;
        }
        ChangedBlock other = (ChangedBlock) obj;
        return Objects.equals(blockIndex(), other.blockIndex()) && Objects.equals(firstBlockToken(), other.firstBlockToken())
                && Objects.equals(secondBlockToken(), other.secondBlockToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangedBlock").add("BlockIndex", blockIndex()).add("FirstBlockToken", firstBlockToken())
                .add("SecondBlockToken", secondBlockToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockIndex":
            return Optional.ofNullable(clazz.cast(blockIndex()));
        case "FirstBlockToken":
            return Optional.ofNullable(clazz.cast(firstBlockToken()));
        case "SecondBlockToken":
            return Optional.ofNullable(clazz.cast(secondBlockToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlockIndex", BLOCK_INDEX_FIELD);
        map.put("FirstBlockToken", FIRST_BLOCK_TOKEN_FIELD);
        map.put("SecondBlockToken", SECOND_BLOCK_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangedBlock, T> g) {
        return obj -> g.apply((ChangedBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangedBlock> {
        /**
         * <p>
         * The block index.
         * </p>
         * 
         * @param blockIndex
         *        The block index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockIndex(Integer blockIndex);

        /**
         * <p>
         * The block token for the block index of the <code>FirstSnapshotId</code> specified in the
         * <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the
         * changed block that is on the second snapshot.
         * </p>
         * 
         * @param firstBlockToken
         *        The block token for the block index of the <code>FirstSnapshotId</code> specified in the
         *        <code>ListChangedBlocks</code> operation. This value is absent if the first snapshot does not have the
         *        changed block that is on the second snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstBlockToken(String firstBlockToken);

        /**
         * <p>
         * The block token for the block index of the <code>SecondSnapshotId</code> specified in the
         * <code>ListChangedBlocks</code> operation.
         * </p>
         * 
         * @param secondBlockToken
         *        The block token for the block index of the <code>SecondSnapshotId</code> specified in the
         *        <code>ListChangedBlocks</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondBlockToken(String secondBlockToken);
    }

    static final class BuilderImpl implements Builder {
        private Integer blockIndex;

        private String firstBlockToken;

        private String secondBlockToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangedBlock model) {
            blockIndex(model.blockIndex);
            firstBlockToken(model.firstBlockToken);
            secondBlockToken(model.secondBlockToken);
        }

        public final Integer getBlockIndex() {
            return blockIndex;
        }

        public final void setBlockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
        }

        @Override
        public final Builder blockIndex(Integer blockIndex) {
            this.blockIndex = blockIndex;
            return this;
        }

        public final String getFirstBlockToken() {
            return firstBlockToken;
        }

        public final void setFirstBlockToken(String firstBlockToken) {
            this.firstBlockToken = firstBlockToken;
        }

        @Override
        public final Builder firstBlockToken(String firstBlockToken) {
            this.firstBlockToken = firstBlockToken;
            return this;
        }

        public final String getSecondBlockToken() {
            return secondBlockToken;
        }

        public final void setSecondBlockToken(String secondBlockToken) {
            this.secondBlockToken = secondBlockToken;
        }

        @Override
        public final Builder secondBlockToken(String secondBlockToken) {
            this.secondBlockToken = secondBlockToken;
            return this;
        }

        @Override
        public ChangedBlock build() {
            return new ChangedBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
