/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ebs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSnapshotBlockResponse extends EbsResponse implements
        ToCopyableBuilder<PutSnapshotBlockResponse.Builder, PutSnapshotBlockResponse> {
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Checksum").getter(getter(PutSnapshotBlockResponse::checksum)).setter(setter(Builder::checksum))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum").build()).build();

    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChecksumAlgorithm").getter(getter(PutSnapshotBlockResponse::checksumAlgorithmAsString))
            .setter(setter(Builder::checksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-Checksum-Algorithm").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECKSUM_FIELD,
            CHECKSUM_ALGORITHM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String checksum;

    private final String checksumAlgorithm;

    private PutSnapshotBlockResponse(BuilderImpl builder) {
        super(builder);
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
    }

    /**
     * <p>
     * The SHA256 checksum generated for the block data by Amazon EBS.
     * </p>
     * 
     * @return The SHA256 checksum generated for the block data by Amazon EBS.
     */
    public final String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The algorithm used by Amazon EBS to generate the checksum.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link ChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm used by Amazon EBS to generate the checksum.
     * @see ChecksumAlgorithm
     */
    public final ChecksumAlgorithm checksumAlgorithm() {
        return ChecksumAlgorithm.fromValue(checksumAlgorithm);
    }

    /**
     * <p>
     * The algorithm used by Amazon EBS to generate the checksum.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checksumAlgorithm}
     * will return {@link ChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #checksumAlgorithmAsString}.
     * </p>
     * 
     * @return The algorithm used by Amazon EBS to generate the checksum.
     * @see ChecksumAlgorithm
     */
    public final String checksumAlgorithmAsString() {
        return checksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(checksum());
        hashCode = 31 * hashCode + Objects.hashCode(checksumAlgorithmAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSnapshotBlockResponse)) {
            return false;
        }
        PutSnapshotBlockResponse other = (PutSnapshotBlockResponse) obj;
        return Objects.equals(checksum(), other.checksum())
                && Objects.equals(checksumAlgorithmAsString(), other.checksumAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSnapshotBlockResponse").add("Checksum", checksum())
                .add("ChecksumAlgorithm", checksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Checksum":
            return Optional.ofNullable(clazz.cast(checksum()));
        case "ChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(checksumAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("x-amz-Checksum", CHECKSUM_FIELD);
        map.put("x-amz-Checksum-Algorithm", CHECKSUM_ALGORITHM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSnapshotBlockResponse, T> g) {
        return obj -> g.apply((PutSnapshotBlockResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EbsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutSnapshotBlockResponse> {
        /**
         * <p>
         * The SHA256 checksum generated for the block data by Amazon EBS.
         * </p>
         * 
         * @param checksum
         *        The SHA256 checksum generated for the block data by Amazon EBS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The algorithm used by Amazon EBS to generate the checksum.
         * </p>
         * 
         * @param checksumAlgorithm
         *        The algorithm used by Amazon EBS to generate the checksum.
         * @see ChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChecksumAlgorithm
         */
        Builder checksumAlgorithm(String checksumAlgorithm);

        /**
         * <p>
         * The algorithm used by Amazon EBS to generate the checksum.
         * </p>
         * 
         * @param checksumAlgorithm
         *        The algorithm used by Amazon EBS to generate the checksum.
         * @see ChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChecksumAlgorithm
         */
        Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm);
    }

    static final class BuilderImpl extends EbsResponse.BuilderImpl implements Builder {
        private String checksum;

        private String checksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSnapshotBlockResponse model) {
            super(model);
            checksum(model.checksum);
            checksumAlgorithm(model.checksumAlgorithm);
        }

        public final String getChecksum() {
            return checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        @Override
        public PutSnapshotBlockResponse build() {
            return new PutSnapshotBlockResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
