/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Spot fleet request that was successfully canceled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelSpotFleetRequestsSuccessItem implements
        ToCopyableBuilder<CancelSpotFleetRequestsSuccessItem.Builder, CancelSpotFleetRequestsSuccessItem> {
    private final String currentSpotFleetRequestState;

    private final String previousSpotFleetRequestState;

    private final String spotFleetRequestId;

    private CancelSpotFleetRequestsSuccessItem(BuilderImpl builder) {
        this.currentSpotFleetRequestState = builder.currentSpotFleetRequestState;
        this.previousSpotFleetRequestState = builder.previousSpotFleetRequestState;
        this.spotFleetRequestId = builder.spotFleetRequestId;
    }

    /**
     * <p>
     * The current state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The current state of the Spot fleet request.
     * @see BatchState
     */
    public BatchState currentSpotFleetRequestState() {
        return BatchState.fromValue(currentSpotFleetRequestState);
    }

    /**
     * <p>
     * The current state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #currentSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The current state of the Spot fleet request.
     * @see BatchState
     */
    public String currentSpotFleetRequestStateAsString() {
        return currentSpotFleetRequestState;
    }

    /**
     * <p>
     * The previous state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #previousSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The previous state of the Spot fleet request.
     * @see BatchState
     */
    public BatchState previousSpotFleetRequestState() {
        return BatchState.fromValue(previousSpotFleetRequestState);
    }

    /**
     * <p>
     * The previous state of the Spot fleet request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #previousSpotFleetRequestState} will return {@link BatchState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #previousSpotFleetRequestStateAsString}.
     * </p>
     * 
     * @return The previous state of the Spot fleet request.
     * @see BatchState
     */
    public String previousSpotFleetRequestStateAsString() {
        return previousSpotFleetRequestState;
    }

    /**
     * <p>
     * The ID of the Spot fleet request.
     * </p>
     * 
     * @return The ID of the Spot fleet request.
     */
    public String spotFleetRequestId() {
        return spotFleetRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousSpotFleetRequestStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(spotFleetRequestId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotFleetRequestsSuccessItem)) {
            return false;
        }
        CancelSpotFleetRequestsSuccessItem other = (CancelSpotFleetRequestsSuccessItem) obj;
        return Objects.equals(currentSpotFleetRequestStateAsString(), other.currentSpotFleetRequestStateAsString())
                && Objects.equals(previousSpotFleetRequestStateAsString(), other.previousSpotFleetRequestStateAsString())
                && Objects.equals(spotFleetRequestId(), other.spotFleetRequestId());
    }

    @Override
    public String toString() {
        return ToString.builder("CancelSpotFleetRequestsSuccessItem")
                .add("CurrentSpotFleetRequestState", currentSpotFleetRequestStateAsString())
                .add("PreviousSpotFleetRequestState", previousSpotFleetRequestStateAsString())
                .add("SpotFleetRequestId", spotFleetRequestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentSpotFleetRequestState":
            return Optional.of(clazz.cast(currentSpotFleetRequestStateAsString()));
        case "PreviousSpotFleetRequestState":
            return Optional.of(clazz.cast(previousSpotFleetRequestStateAsString()));
        case "SpotFleetRequestId":
            return Optional.of(clazz.cast(spotFleetRequestId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CancelSpotFleetRequestsSuccessItem> {
        /**
         * <p>
         * The current state of the Spot fleet request.
         * </p>
         * 
         * @param currentSpotFleetRequestState
         *        The current state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder currentSpotFleetRequestState(String currentSpotFleetRequestState);

        /**
         * <p>
         * The current state of the Spot fleet request.
         * </p>
         * 
         * @param currentSpotFleetRequestState
         *        The current state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState);

        /**
         * <p>
         * The previous state of the Spot fleet request.
         * </p>
         * 
         * @param previousSpotFleetRequestState
         *        The previous state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder previousSpotFleetRequestState(String previousSpotFleetRequestState);

        /**
         * <p>
         * The previous state of the Spot fleet request.
         * </p>
         * 
         * @param previousSpotFleetRequestState
         *        The previous state of the Spot fleet request.
         * @see BatchState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchState
         */
        Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState);

        /**
         * <p>
         * The ID of the Spot fleet request.
         * </p>
         * 
         * @param spotFleetRequestId
         *        The ID of the Spot fleet request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotFleetRequestId(String spotFleetRequestId);
    }

    static final class BuilderImpl implements Builder {
        private String currentSpotFleetRequestState;

        private String previousSpotFleetRequestState;

        private String spotFleetRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSpotFleetRequestsSuccessItem model) {
            currentSpotFleetRequestState(model.currentSpotFleetRequestState);
            previousSpotFleetRequestState(model.previousSpotFleetRequestState);
            spotFleetRequestId(model.spotFleetRequestId);
        }

        public final String getCurrentSpotFleetRequestState() {
            return currentSpotFleetRequestState;
        }

        @Override
        public final Builder currentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder currentSpotFleetRequestState(BatchState currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState(currentSpotFleetRequestState.toString());
            return this;
        }

        public final void setCurrentSpotFleetRequestState(String currentSpotFleetRequestState) {
            this.currentSpotFleetRequestState = currentSpotFleetRequestState;
        }

        public final String getPreviousSpotFleetRequestState() {
            return previousSpotFleetRequestState;
        }

        @Override
        public final Builder previousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
            return this;
        }

        @Override
        public final Builder previousSpotFleetRequestState(BatchState previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState(previousSpotFleetRequestState.toString());
            return this;
        }

        public final void setPreviousSpotFleetRequestState(String previousSpotFleetRequestState) {
            this.previousSpotFleetRequestState = previousSpotFleetRequestState;
        }

        public final String getSpotFleetRequestId() {
            return spotFleetRequestId;
        }

        @Override
        public final Builder spotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
            return this;
        }

        public final void setSpotFleetRequestId(String spotFleetRequestId) {
            this.spotFleetRequestId = spotFleetRequestId;
        }

        @Override
        public CancelSpotFleetRequestsSuccessItem build() {
            return new CancelSpotFleetRequestsSuccessItem(this);
        }
    }
}
