/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCustomerGatewayResponse extends EC2Response implements
        ToCopyableBuilder<CreateCustomerGatewayResponse.Builder, CreateCustomerGatewayResponse> {
    private final CustomerGateway customerGateway;

    private CreateCustomerGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateway = builder.customerGateway;
    }

    /**
     * <p>
     * Information about the customer gateway.
     * </p>
     * 
     * @return Information about the customer gateway.
     */
    public CustomerGateway customerGateway() {
        return customerGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayResponse)) {
            return false;
        }
        CreateCustomerGatewayResponse other = (CreateCustomerGatewayResponse) obj;
        return Objects.equals(customerGateway(), other.customerGateway());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateCustomerGatewayResponse").add("CustomerGateway", customerGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomerGateway":
            return Optional.of(clazz.cast(customerGateway()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateCustomerGatewayResponse> {
        /**
         * <p>
         * Information about the customer gateway.
         * </p>
         * 
         * @param customerGateway
         *        Information about the customer gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerGateway(CustomerGateway customerGateway);

        /**
         * <p>
         * Information about the customer gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerGateway.Builder} avoiding the need to
         * create one manually via {@link CustomerGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #customerGateway(CustomerGateway)}.
         * 
         * @param customerGateway
         *        a consumer that will call methods on {@link CustomerGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerGateway(CustomerGateway)
         */
        default Builder customerGateway(Consumer<CustomerGateway.Builder> customerGateway) {
            return customerGateway(CustomerGateway.builder().apply(customerGateway).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private CustomerGateway customerGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayResponse model) {
            super(model);
            customerGateway(model.customerGateway);
        }

        public final CustomerGateway.Builder getCustomerGateway() {
            return customerGateway != null ? customerGateway.toBuilder() : null;
        }

        @Override
        public final Builder customerGateway(CustomerGateway customerGateway) {
            this.customerGateway = customerGateway;
            return this;
        }

        public final void setCustomerGateway(CustomerGateway.BuilderImpl customerGateway) {
            this.customerGateway = customerGateway != null ? customerGateway.build() : null;
        }

        @Override
        public CreateCustomerGatewayResponse build() {
            return new CreateCustomerGatewayResponse(this);
        }
    }
}
