/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateDhcpOptions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDhcpOptionsRequest extends EC2Request implements
        ToCopyableBuilder<CreateDhcpOptionsRequest.Builder, CreateDhcpOptionsRequest> {
    private final List<DhcpConfiguration> dhcpConfigurations;

    private CreateDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpConfigurations = builder.dhcpConfigurations;
    }

    /**
     * <p>
     * A DHCP configuration option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A DHCP configuration option.
     */
    public List<DhcpConfiguration> dhcpConfigurations() {
        return dhcpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dhcpConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest) obj;
        return Objects.equals(dhcpConfigurations(), other.dhcpConfigurations());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDhcpOptionsRequest").add("DhcpConfigurations", dhcpConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpConfigurations":
            return Optional.of(clazz.cast(dhcpConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateDhcpOptionsRequest> {
        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * 
         * @param dhcpConfigurations
         *        A DHCP configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations);

        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * 
         * @param dhcpConfigurations
         *        A DHCP configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations);

        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DhcpConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<DhcpConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DhcpConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #dhcpConfigurations(List<DhcpConfiguration>)}.
         * 
         * @param dhcpConfigurations
         *        a consumer that will call methods on {@link List<DhcpConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpConfigurations(List<DhcpConfiguration>)
         */
        Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsRequest model) {
            super(model);
            dhcpConfigurations(model.dhcpConfigurations);
        }

        public final Collection<DhcpConfiguration.Builder> getDhcpConfigurations() {
            return dhcpConfigurations != null ? dhcpConfigurations.stream().map(DhcpConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration... dhcpConfigurations) {
            dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder>... dhcpConfigurations) {
            dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> DhcpConfiguration.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDhcpOptionsRequest build() {
            return new CreateDhcpOptionsRequest(this);
        }
    }
}
