/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for CreateInstanceExportTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInstanceExportTaskResponse extends EC2Response implements
        ToCopyableBuilder<CreateInstanceExportTaskResponse.Builder, CreateInstanceExportTaskResponse> {
    private final ExportTask exportTask;

    private CreateInstanceExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.exportTask = builder.exportTask;
    }

    /**
     * <p>
     * Information about the instance export task.
     * </p>
     * 
     * @return Information about the instance export task.
     */
    public ExportTask exportTask() {
        return exportTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportTask());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskResponse)) {
            return false;
        }
        CreateInstanceExportTaskResponse other = (CreateInstanceExportTaskResponse) obj;
        return Objects.equals(exportTask(), other.exportTask());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateInstanceExportTaskResponse").add("ExportTask", exportTask()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportTask":
            return Optional.of(clazz.cast(exportTask()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, CreateInstanceExportTaskResponse> {
        /**
         * <p>
         * Information about the instance export task.
         * </p>
         * 
         * @param exportTask
         *        Information about the instance export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTask(ExportTask exportTask);

        /**
         * <p>
         * Information about the instance export task.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportTask.Builder} avoiding the need to create
         * one manually via {@link ExportTask#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportTask.Builder#build()} is called immediately and its result
         * is passed to {@link #exportTask(ExportTask)}.
         * 
         * @param exportTask
         *        a consumer that will call methods on {@link ExportTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportTask(ExportTask)
         */
        default Builder exportTask(Consumer<ExportTask.Builder> exportTask) {
            return exportTask(ExportTask.builder().apply(exportTask).build());
        }
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private ExportTask exportTask;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskResponse model) {
            super(model);
            exportTask(model.exportTask);
        }

        public final ExportTask.Builder getExportTask() {
            return exportTask != null ? exportTask.toBuilder() : null;
        }

        @Override
        public final Builder exportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
            return this;
        }

        public final void setExportTask(ExportTask.BuilderImpl exportTask) {
            this.exportTask = exportTask != null ? exportTask.build() : null;
        }

        @Override
        public CreateInstanceExportTaskResponse build() {
            return new CreateInstanceExportTaskResponse(this);
        }
    }
}
