/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the user or group to be added or removed from the permissions for a volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVolumePermission implements ToCopyableBuilder<CreateVolumePermission.Builder, CreateVolumePermission> {
    private final String group;

    private final String userId;

    private CreateVolumePermission(BuilderImpl builder) {
        this.group = builder.group;
        this.userId = builder.userId;
    }

    /**
     * <p>
     * The specific group that is to be added or removed from a volume's list of create volume permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The specific group that is to be added or removed from a volume's list of create volume permissions.
     * @see PermissionGroup
     */
    public PermissionGroup group() {
        return PermissionGroup.fromValue(group);
    }

    /**
     * <p>
     * The specific group that is to be added or removed from a volume's list of create volume permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #group} will return
     * {@link PermissionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #groupAsString}.
     * </p>
     * 
     * @return The specific group that is to be added or removed from a volume's list of create volume permissions.
     * @see PermissionGroup
     */
    public String groupAsString() {
        return group;
    }

    /**
     * <p>
     * The specific AWS account ID that is to be added or removed from a volume's list of create volume permissions.
     * </p>
     * 
     * @return The specific AWS account ID that is to be added or removed from a volume's list of create volume
     *         permissions.
     */
    public String userId() {
        return userId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumePermission)) {
            return false;
        }
        CreateVolumePermission other = (CreateVolumePermission) obj;
        return Objects.equals(groupAsString(), other.groupAsString()) && Objects.equals(userId(), other.userId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVolumePermission").add("Group", groupAsString()).add("UserId", userId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.of(clazz.cast(groupAsString()));
        case "UserId":
            return Optional.of(clazz.cast(userId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVolumePermission> {
        /**
         * <p>
         * The specific group that is to be added or removed from a volume's list of create volume permissions.
         * </p>
         * 
         * @param group
         *        The specific group that is to be added or removed from a volume's list of create volume permissions.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(String group);

        /**
         * <p>
         * The specific group that is to be added or removed from a volume's list of create volume permissions.
         * </p>
         * 
         * @param group
         *        The specific group that is to be added or removed from a volume's list of create volume permissions.
         * @see PermissionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PermissionGroup
         */
        Builder group(PermissionGroup group);

        /**
         * <p>
         * The specific AWS account ID that is to be added or removed from a volume's list of create volume permissions.
         * </p>
         * 
         * @param userId
         *        The specific AWS account ID that is to be added or removed from a volume's list of create volume
         *        permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);
    }

    static final class BuilderImpl implements Builder {
        private String group;

        private String userId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumePermission model) {
            group(model.group);
            userId(model.userId);
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        @Override
        public final Builder group(PermissionGroup group) {
            this.group(group.toString());
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public CreateVolumePermission build() {
            return new CreateVolumePermission(this);
        }
    }
}
