/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcPeeringConnectionRequest extends EC2Request implements
        ToCopyableBuilder<CreateVpcPeeringConnectionRequest.Builder, CreateVpcPeeringConnectionRequest> {
    private final String peerOwnerId;

    private final String peerVpcId;

    private final String vpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.peerOwnerId = builder.peerOwnerId;
        this.peerVpcId = builder.peerVpcId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the peer VPC.
     * </p>
     * <p>
     * Default: Your AWS account ID
     * </p>
     * 
     * @return The AWS account ID of the owner of the peer VPC.</p>
     *         <p>
     *         Default: Your AWS account ID
     */
    public String peerOwnerId() {
        return peerOwnerId;
    }

    /**
     * <p>
     * The ID of the VPC with which you are creating the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC with which you are creating the VPC peering connection.
     */
    public String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * The ID of the requester VPC.
     * </p>
     * 
     * @return The ID of the requester VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peerOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest) obj;
        return Objects.equals(peerOwnerId(), other.peerOwnerId()) && Objects.equals(peerVpcId(), other.peerVpcId())
                && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateVpcPeeringConnectionRequest").add("PeerOwnerId", peerOwnerId())
                .add("PeerVpcId", peerVpcId()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerOwnerId":
            return Optional.of(clazz.cast(peerOwnerId()));
        case "PeerVpcId":
            return Optional.of(clazz.cast(peerVpcId()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        /**
         * <p>
         * The AWS account ID of the owner of the peer VPC.
         * </p>
         * <p>
         * Default: Your AWS account ID
         * </p>
         * 
         * @param peerOwnerId
         *        The AWS account ID of the owner of the peer VPC.</p>
         *        <p>
         *        Default: Your AWS account ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerOwnerId(String peerOwnerId);

        /**
         * <p>
         * The ID of the VPC with which you are creating the VPC peering connection.
         * </p>
         * 
         * @param peerVpcId
         *        The ID of the VPC with which you are creating the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * The ID of the requester VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String peerOwnerId;

        private String peerVpcId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            super(model);
            peerOwnerId(model.peerOwnerId);
            peerVpcId(model.peerVpcId);
            vpcId(model.vpcId);
        }

        public final String getPeerOwnerId() {
            return peerOwnerId;
        }

        @Override
        public final Builder peerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        public final void setPeerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }
    }
}
