/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeClassicLinkInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeClassicLinkInstancesRequest extends EC2Request implements
        ToCopyableBuilder<DescribeClassicLinkInstancesRequest.Builder, DescribeClassicLinkInstancesRequest> {
    private final List<Filter> filters;

    private final List<String> instanceIds;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeClassicLinkInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.instanceIds = builder.instanceIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-id</code> - The ID of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-id</code> - The ID of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of results to return for the request in a single page. The remaining results of the initial
     * request can be seen by sending another request with the returned <code>NextToken</code> value. This value can be
     * between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000 results are returned.
     * You cannot specify this parameter and the instance IDs parameter in the same request.
     * </p>
     * <p>
     * Constraint: If the value is greater than 1000, we return only 1000 items.
     * </p>
     * 
     * @return The maximum number of results to return for the request in a single page. The remaining results of the
     *         initial request can be seen by sending another request with the returned <code>NextToken</code> value.
     *         This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only
     *         1000 results are returned. You cannot specify this parameter and the instance IDs parameter in the same
     *         request.</p>
     *         <p>
     *         Constraint: If the value is greater than 1000, we return only 1000 items.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClassicLinkInstancesRequest)) {
            return false;
        }
        DescribeClassicLinkInstancesRequest other = (DescribeClassicLinkInstancesRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeClassicLinkInstancesRequest").add("Filters", filters())
                .add("InstanceIds", instanceIds()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeClassicLinkInstancesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-id</code> - The ID of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>group-id</code> - The ID of a VPC security group that's associated with the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-id</code> - The ID of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-id</code> - The ID of the VPC that the instance is linked to.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs. Must be instances linked to a VPC through ClassicLink.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of results to return for the request in a single page. The remaining results of the
         * initial request can be seen by sending another request with the returned <code>NextToken</code> value. This
         * value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000, only 1000
         * results are returned. You cannot specify this parameter and the instance IDs parameter in the same request.
         * </p>
         * <p>
         * Constraint: If the value is greater than 1000, we return only 1000 items.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return for the request in a single page. The remaining results of the
         *        initial request can be seen by sending another request with the returned <code>NextToken</code> value.
         *        This value can be between 5 and 1000; if <code>MaxResults</code> is given a value larger than 1000,
         *        only 1000 results are returned. You cannot specify this parameter and the instance IDs parameter in
         *        the same request.</p>
         *        <p>
         *        Constraint: If the value is greater than 1000, we return only 1000 items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> instanceIds;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClassicLinkInstancesRequest model) {
            super(model);
            filters(model.filters);
            instanceIds(model.instanceIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeClassicLinkInstancesRequest build() {
            return new DescribeClassicLinkInstancesRequest(this);
        }
    }
}
