/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeIdentityIdFormat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIdentityIdFormatRequest extends EC2Request implements
        ToCopyableBuilder<DescribeIdentityIdFormatRequest.Builder, DescribeIdentityIdFormatRequest> {
    private final String principalArn;

    private final String resource;

    private DescribeIdentityIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The ARN of the principal, which can be an IAM role, IAM user, or the root user.
     * </p>
     * 
     * @return The ARN of the principal, which can be an IAM role, IAM user, or the root user.
     */
    public String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
     * <code>volume</code>
     * </p>
     * 
     * @return The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
     *         <code>volume</code>
     */
    public String resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatRequest)) {
            return false;
        }
        DescribeIdentityIdFormatRequest other = (DescribeIdentityIdFormatRequest) obj;
        return Objects.equals(principalArn(), other.principalArn()) && Objects.equals(resource(), other.resource());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeIdentityIdFormatRequest").add("PrincipalArn", principalArn())
                .add("Resource", resource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalArn":
            return Optional.of(clazz.cast(principalArn()));
        case "Resource":
            return Optional.of(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeIdentityIdFormatRequest> {
        /**
         * <p>
         * The ARN of the principal, which can be an IAM role, IAM user, or the root user.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the principal, which can be an IAM role, IAM user, or the root user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
         * <code>volume</code>
         * </p>
         * 
         * @param resource
         *        The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
         *        <code>volume</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String principalArn;

        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatRequest model) {
            super(model);
            principalArn(model.principalArn);
            resource(model.resource);
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeIdentityIdFormatRequest build() {
            return new DescribeIdentityIdFormatRequest(this);
        }
    }
}
