/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeInstanceStatus.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstanceStatusRequest extends EC2Request implements
        ToCopyableBuilder<DescribeInstanceStatusRequest.Builder, DescribeInstanceStatusRequest> {
    private final List<Filter> filters;

    private final List<String> instanceIds;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean includeAllInstances;

    private DescribeInstanceStatusRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.instanceIds = builder.instanceIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeAllInstances = builder.includeAllInstances;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>availability-zone</code> - The Availability Zone of the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
     * <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
     * <code>instance-stop</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.description</code> - A description of the event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-after</code> - The latest end time for the scheduled event (for example,
     * <code>2014-09-15T17:15:20.000Z</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
     * <code>2014-09-15T17:15:20.000Z</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high byte
     * is an opaque internal value and should be ignored. The low byte is set based on the state represented. The valid
     * values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
     * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-status.reachability</code> - Filters on instance status where the name is
     * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
     * <code>insufficient-data</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> |
     * <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>system-status.reachability</code> - Filters on system status where the name is <code>reachability</code> (
     * <code>passed</code> | <code>failed</code> | <code>initializing</code> | <code>insufficient-data</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>system-status.status</code> - The system status of the instance (<code>ok</code> | <code>impaired</code> |
     * <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>availability-zone</code> - The Availability Zone of the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
     *         <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
     *         <code>instance-stop</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.description</code> - A description of the event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-after</code> - The latest end time for the scheduled event (for example,
     *         <code>2014-09-15T17:15:20.000Z</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
     *         <code>2014-09-15T17:15:20.000Z</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The
     *         high byte is an opaque internal value and should be ignored. The low byte is set based on the state
     *         represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
     *         (stopping), and 80 (stopped).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code>
     *         | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-status.reachability</code> - Filters on instance status where the name is
     *         <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
     *         <code>insufficient-data</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code>
     *         | <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>system-status.reachability</code> - Filters on system status where the name is
     *         <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
     *         <code>insufficient-data</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
     *         <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
     *         <code>not-applicable</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more instance IDs.
     * </p>
     * <p>
     * Default: Describes all your instances.
     * </p>
     * <p>
     * Constraints: Maximum 100 explicitly specified instance IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more instance IDs.</p>
     *         <p>
     *         Default: Describes all your instances.
     *         </p>
     *         <p>
     *         Constraints: Maximum 100 explicitly specified instance IDs.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify this
     * parameter and the instance IDs parameter in the same call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot
     *         specify this parameter and the instance IDs parameter in the same call.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next page of results.
     * </p>
     * 
     * @return The token to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the
     * health status for running instances only.
     * </p>
     * <p>
     * Default: <code>false</code>
     * </p>
     * 
     * @return When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes
     *         the health status for running instances only.</p>
     *         <p>
     *         Default: <code>false</code>
     */
    public Boolean includeAllInstances() {
        return includeAllInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeAllInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusRequest)) {
            return false;
        }
        DescribeInstanceStatusRequest other = (DescribeInstanceStatusRequest) obj;
        return Objects.equals(filters(), other.filters()) && Objects.equals(instanceIds(), other.instanceIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(includeAllInstances(), other.includeAllInstances());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceStatusRequest").add("Filters", filters()).add("InstanceIds", instanceIds())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("IncludeAllInstances", includeAllInstances())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "IncludeAllInstances":
            return Optional.of(clazz.cast(includeAllInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeInstanceStatusRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
         * <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
         * <code>instance-stop</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high
         * byte is an opaque internal value and should be ignored. The low byte is set based on the state represented.
         * The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.reachability</code> - Filters on instance status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> |
         * <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.reachability</code> - Filters on system status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
         * <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         * <code>not-applicable</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
         *        <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
         *        <code>instance-stop</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the scheduled event (for example,
         *        <code>2014-09-15T17:15:20.000Z</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
         *        <code>2014-09-15T17:15:20.000Z</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The
         *        high byte is an opaque internal value and should be ignored. The low byte is set based on the state
         *        represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-status.reachability</code> - Filters on instance status where the name is
         *        <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         *        <code>insufficient-data</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-status.status</code> - The status of the instance (<code>ok</code> |
         *        <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         *        <code>not-applicable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>system-status.reachability</code> - Filters on system status where the name is
         *        <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         *        <code>insufficient-data</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
         *        <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         *        <code>not-applicable</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
         * <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
         * <code>instance-stop</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high
         * byte is an opaque internal value and should be ignored. The low byte is set based on the state represented.
         * The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.reachability</code> - Filters on instance status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> |
         * <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.reachability</code> - Filters on system status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
         * <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         * <code>not-applicable</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>availability-zone</code> - The Availability Zone of the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
         *        <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
         *        <code>instance-stop</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.description</code> - A description of the event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-after</code> - The latest end time for the scheduled event (for example,
         *        <code>2014-09-15T17:15:20.000Z</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
         *        <code>2014-09-15T17:15:20.000Z</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The
         *        high byte is an opaque internal value and should be ignored. The low byte is set based on the state
         *        represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64
         *        (stopping), and 80 (stopped).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-state-name</code> - The state of the instance (<code>pending</code> |
         *        <code>running</code> | <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> |
         *        <code>stopped</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-status.reachability</code> - Filters on instance status where the name is
         *        <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         *        <code>insufficient-data</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>instance-status.status</code> - The status of the instance (<code>ok</code> |
         *        <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         *        <code>not-applicable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>system-status.reachability</code> - Filters on system status where the name is
         *        <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         *        <code>insufficient-data</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
         *        <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         *        <code>not-applicable</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>availability-zone</code> - The Availability Zone of the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.code</code> - The code for the scheduled event (<code>instance-reboot</code> |
         * <code>system-reboot</code> | <code>system-maintenance</code> | <code>instance-retirement</code> |
         * <code>instance-stop</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.description</code> - A description of the event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-after</code> - The latest end time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>event.not-before</code> - The earliest start time for the scheduled event (for example,
         * <code>2014-09-15T17:15:20.000Z</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-code</code> - The code for the instance state, as a 16-bit unsigned integer. The high
         * byte is an opaque internal value and should be ignored. The low byte is set based on the state represented.
         * The valid values are 0 (pending), 16 (running), 32 (shutting-down), 48 (terminated), 64 (stopping), and 80
         * (stopped).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-state-name</code> - The state of the instance (<code>pending</code> | <code>running</code> |
         * <code>shutting-down</code> | <code>terminated</code> | <code>stopping</code> | <code>stopped</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.reachability</code> - Filters on instance status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>instance-status.status</code> - The status of the instance (<code>ok</code> | <code>impaired</code> |
         * <code>initializing</code> | <code>insufficient-data</code> | <code>not-applicable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.reachability</code> - Filters on system status where the name is
         * <code>reachability</code> (<code>passed</code> | <code>failed</code> | <code>initializing</code> |
         * <code>insufficient-data</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>system-status.status</code> - The system status of the instance (<code>ok</code> |
         * <code>impaired</code> | <code>initializing</code> | <code>insufficient-data</code> |
         * <code>not-applicable</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * <p>
         * Constraints: Maximum 100 explicitly specified instance IDs.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         *        </p>
         *        <p>
         *        Constraints: Maximum 100 explicitly specified instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * One or more instance IDs.
         * </p>
         * <p>
         * Default: Describes all your instances.
         * </p>
         * <p>
         * Constraints: Maximum 100 explicitly specified instance IDs.
         * </p>
         * 
         * @param instanceIds
         *        One or more instance IDs.</p>
         *        <p>
         *        Default: Describes all your instances.
         *        </p>
         *        <p>
         *        Constraints: Maximum 100 explicitly specified instance IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You cannot specify
         * this parameter and the instance IDs parameter in the same call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. This value can be between 5 and 1000. You
         *        cannot specify this parameter and the instance IDs parameter in the same call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * When <code>true</code>, includes the health status for all instances. When <code>false</code>, includes the
         * health status for running instances only.
         * </p>
         * <p>
         * Default: <code>false</code>
         * </p>
         * 
         * @param includeAllInstances
         *        When <code>true</code>, includes the health status for all instances. When <code>false</code>,
         *        includes the health status for running instances only.</p>
         *        <p>
         *        Default: <code>false</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAllInstances(Boolean includeAllInstances);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> instanceIds;

        private Integer maxResults;

        private String nextToken;

        private Boolean includeAllInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusRequest model) {
            super(model);
            filters(model.filters);
            instanceIds(model.instanceIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            includeAllInstances(model.includeAllInstances);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdStringListCopier.copy(instanceIds);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getIncludeAllInstances() {
            return includeAllInstances;
        }

        @Override
        public final Builder includeAllInstances(Boolean includeAllInstances) {
            this.includeAllInstances = includeAllInstances;
            return this;
        }

        public final void setIncludeAllInstances(Boolean includeAllInstances) {
            this.includeAllInstances = includeAllInstances;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceStatusRequest build() {
            return new DescribeInstanceStatusRequest(this);
        }
    }
}
