/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeNetworkInterfacePermissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfacePermissionsRequest extends EC2Request implements
        ToCopyableBuilder<DescribeNetworkInterfacePermissionsRequest.Builder, DescribeNetworkInterfacePermissionsRequest> {
    private final List<String> networkInterfacePermissionIds;

    private final List<Filter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private DescribeNetworkInterfacePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissionIds = builder.networkInterfacePermissionIds;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * One or more network interface permission IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more network interface permission IDs.
     */
    public List<String> networkInterfacePermissionIds() {
        return networkInterfacePermissionIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-permission.aws-service</code> - The AWS service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> |
     * <code>EIP-ASSOCIATE</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-permission.aws-service</code> - The AWS service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>network-interface-permission.permission</code> - The type of permission (
     *         <code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The token to request the next page of results.
     * </p>
     * 
     * @return The token to request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call
     * with the returned <code>NextToken</code> value. If this parameter is not specified, up to 50 results are returned
     * by default.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. To retrieve the remaining results, make another
     *         call with the returned <code>NextToken</code> value. If this parameter is not specified, up to 50 results
     *         are returned by default.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePermissionIds());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsRequest)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsRequest other = (DescribeNetworkInterfacePermissionsRequest) obj;
        return Objects.equals(networkInterfacePermissionIds(), other.networkInterfacePermissionIds())
                && Objects.equals(filters(), other.filters()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkInterfacePermissionsRequest")
                .add("NetworkInterfacePermissionIds", networkInterfacePermissionIds()).add("Filters", filters())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissionIds":
            return Optional.of(clazz.cast(networkInterfacePermissionIds()));
        case "Filters":
            return Optional.of(clazz.cast(filters()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.of(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsRequest> {
        /**
         * <p>
         * One or more network interface permission IDs.
         * </p>
         * 
         * @param networkInterfacePermissionIds
         *        One or more network interface permission IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissionIds(Collection<String> networkInterfacePermissionIds);

        /**
         * <p>
         * One or more network interface permission IDs.
         * </p>
         * 
         * @param networkInterfacePermissionIds
         *        One or more network interface permission IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissionIds(String... networkInterfacePermissionIds);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-service</code> - The AWS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> |
         * <code>EIP-ASSOCIATE</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.aws-service</code> - The AWS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.permission</code> - The type of permission (
         *        <code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-service</code> - The AWS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> |
         * <code>EIP-ASSOCIATE</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.aws-service</code> - The AWS service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>network-interface-permission.permission</code> - The type of permission (
         *        <code>INSTANCE-ATTACH</code> | <code>EIP-ASSOCIATE</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-permission-id</code> - The ID of the permission.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.network-interface-id</code> - The ID of the network interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-account-id</code> - The AWS account ID.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.aws-service</code> - The AWS service.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>network-interface-permission.permission</code> - The type of permission (<code>INSTANCE-ATTACH</code> |
         * <code>EIP-ASSOCIATE</code>).
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The token to request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another
         * call with the returned <code>NextToken</code> value. If this parameter is not specified, up to 50 results are
         * returned by default.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. To retrieve the remaining results, make
         *        another call with the returned <code>NextToken</code> value. If this parameter is not specified, up to
         *        50 results are returned by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private List<String> networkInterfacePermissionIds;

        private List<Filter> filters;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsRequest model) {
            super(model);
            networkInterfacePermissionIds(model.networkInterfacePermissionIds);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getNetworkInterfacePermissionIds() {
            return networkInterfacePermissionIds;
        }

        @Override
        public final Builder networkInterfacePermissionIds(Collection<String> networkInterfacePermissionIds) {
            this.networkInterfacePermissionIds = NetworkInterfacePermissionIdListCopier.copy(networkInterfacePermissionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissionIds(String... networkInterfacePermissionIds) {
            networkInterfacePermissionIds(Arrays.asList(networkInterfacePermissionIds));
            return this;
        }

        public final void setNetworkInterfacePermissionIds(Collection<String> networkInterfacePermissionIds) {
            this.networkInterfacePermissionIds = NetworkInterfacePermissionIdListCopier.copy(networkInterfacePermissionIds);
        }

        public final Collection<Filter.Builder> getFilters() {
            return filters != null ? filters.stream().map(Filter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeNetworkInterfacePermissionsRequest build() {
            return new DescribeNetworkInterfacePermissionsRequest(this);
        }
    }
}
