/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeNetworkInterfacePermissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNetworkInterfacePermissionsResponse extends EC2Response implements
        ToCopyableBuilder<DescribeNetworkInterfacePermissionsResponse.Builder, DescribeNetworkInterfacePermissionsResponse> {
    private final List<NetworkInterfacePermission> networkInterfacePermissions;

    private final String nextToken;

    private DescribeNetworkInterfacePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfacePermissions = builder.networkInterfacePermissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The network interface permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The network interface permissions.
     */
    public List<NetworkInterfacePermission> networkInterfacePermissions() {
        return networkInterfacePermissions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfacePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacePermissionsResponse)) {
            return false;
        }
        DescribeNetworkInterfacePermissionsResponse other = (DescribeNetworkInterfacePermissionsResponse) obj;
        return Objects.equals(networkInterfacePermissions(), other.networkInterfacePermissions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNetworkInterfacePermissionsResponse")
                .add("NetworkInterfacePermissions", networkInterfacePermissions()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkInterfacePermissions":
            return Optional.of(clazz.cast(networkInterfacePermissions()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeNetworkInterfacePermissionsResponse> {
        /**
         * <p>
         * The network interface permissions.
         * </p>
         * 
         * @param networkInterfacePermissions
         *        The network interface permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions);

        /**
         * <p>
         * The network interface permissions.
         * </p>
         * 
         * @param networkInterfacePermissions
         *        The network interface permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfacePermissions(NetworkInterfacePermission... networkInterfacePermissions);

        /**
         * <p>
         * The network interface permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkInterfacePermission>.Builder}
         * avoiding the need to create one manually via {@link List<NetworkInterfacePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkInterfacePermission>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #networkInterfacePermissions(List<NetworkInterfacePermission>)}.
         * 
         * @param networkInterfacePermissions
         *        a consumer that will call methods on {@link List<NetworkInterfacePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfacePermissions(List<NetworkInterfacePermission>)
         */
        Builder networkInterfacePermissions(Consumer<NetworkInterfacePermission.Builder>... networkInterfacePermissions);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<NetworkInterfacePermission> networkInterfacePermissions;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkInterfacePermissionsResponse model) {
            super(model);
            networkInterfacePermissions(model.networkInterfacePermissions);
            nextToken(model.nextToken);
        }

        public final Collection<NetworkInterfacePermission.Builder> getNetworkInterfacePermissions() {
            return networkInterfacePermissions != null ? networkInterfacePermissions.stream()
                    .map(NetworkInterfacePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder networkInterfacePermissions(Collection<NetworkInterfacePermission> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copy(networkInterfacePermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(NetworkInterfacePermission... networkInterfacePermissions) {
            networkInterfacePermissions(Arrays.asList(networkInterfacePermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacePermissions(
                Consumer<NetworkInterfacePermission.Builder>... networkInterfacePermissions) {
            networkInterfacePermissions(Stream.of(networkInterfacePermissions)
                    .map(c -> NetworkInterfacePermission.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfacePermissions(
                Collection<NetworkInterfacePermission.BuilderImpl> networkInterfacePermissions) {
            this.networkInterfacePermissions = NetworkInterfacePermissionListCopier.copyFromBuilder(networkInterfacePermissions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNetworkInterfacePermissionsResponse build() {
            return new DescribeNetworkInterfacePermissionsResponse(this);
        }
    }
}
