/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output for DescribeReservedInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeReservedInstancesResponse extends EC2Response implements
        ToCopyableBuilder<DescribeReservedInstancesResponse.Builder, DescribeReservedInstancesResponse> {
    private final List<ReservedInstances> reservedInstances;

    private DescribeReservedInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstances = builder.reservedInstances;
    }

    /**
     * <p>
     * A list of Reserved Instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Reserved Instances.
     */
    public List<ReservedInstances> reservedInstances() {
        return reservedInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesResponse)) {
            return false;
        }
        DescribeReservedInstancesResponse other = (DescribeReservedInstancesResponse) obj;
        return Objects.equals(reservedInstances(), other.reservedInstances());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeReservedInstancesResponse").add("ReservedInstances", reservedInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedInstances":
            return Optional.of(clazz.cast(reservedInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeReservedInstancesResponse> {
        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(Collection<ReservedInstances> reservedInstances);

        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * 
         * @param reservedInstances
         *        A list of Reserved Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstances(ReservedInstances... reservedInstances);

        /**
         * <p>
         * A list of Reserved Instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedInstances>.Builder} avoiding the
         * need to create one manually via {@link List<ReservedInstances>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedInstances>.Builder#build()} is called immediately
         * and its result is passed to {@link #reservedInstances(List<ReservedInstances>)}.
         * 
         * @param reservedInstances
         *        a consumer that will call methods on {@link List<ReservedInstances>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedInstances(List<ReservedInstances>)
         */
        Builder reservedInstances(Consumer<ReservedInstances.Builder>... reservedInstances);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<ReservedInstances> reservedInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesResponse model) {
            super(model);
            reservedInstances(model.reservedInstances);
        }

        public final Collection<ReservedInstances.Builder> getReservedInstances() {
            return reservedInstances != null ? reservedInstances.stream().map(ReservedInstances::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstances(Collection<ReservedInstances> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copy(reservedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(ReservedInstances... reservedInstances) {
            reservedInstances(Arrays.asList(reservedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstances(Consumer<ReservedInstances.Builder>... reservedInstances) {
            reservedInstances(Stream.of(reservedInstances).map(c -> ReservedInstances.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstances(Collection<ReservedInstances.BuilderImpl> reservedInstances) {
            this.reservedInstances = ReservedInstancesListCopier.copyFromBuilder(reservedInstances);
        }

        @Override
        public DescribeReservedInstancesResponse build() {
            return new DescribeReservedInstancesResponse(this);
        }
    }
}
