/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcAttributeResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVpcAttributeResponse.Builder, DescribeVpcAttributeResponse> {
    private final String vpcId;

    private final Boolean enableDnsHostnames;

    private final Boolean enableDnsSupport;

    private DescribeVpcAttributeResponse(BuilderImpl builder) {
        super(builder);
        this.vpcId = builder.vpcId;
        this.enableDnsHostnames = builder.enableDnsHostnames;
        this.enableDnsSupport = builder.enableDnsSupport;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>,
     * instances in the VPC get DNS hostnames; otherwise, they do not.
     * </p>
     * 
     * @return Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is
     *         <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.
     */
    public Boolean enableDnsHostnames() {
        return enableDnsHostnames;
    }

    /**
     * <p>
     * Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon DNS
     * server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does not.
     * </p>
     * 
     * @return Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the
     *         Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses;
     *         otherwise, it does not.
     */
    public Boolean enableDnsSupport() {
        return enableDnsSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsHostnames());
        hashCode = 31 * hashCode + Objects.hashCode(enableDnsSupport());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcAttributeResponse)) {
            return false;
        }
        DescribeVpcAttributeResponse other = (DescribeVpcAttributeResponse) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(enableDnsHostnames(), other.enableDnsHostnames())
                && Objects.equals(enableDnsSupport(), other.enableDnsSupport());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpcAttributeResponse").add("VpcId", vpcId())
                .add("EnableDnsHostnames", enableDnsHostnames()).add("EnableDnsSupport", enableDnsSupport()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "EnableDnsHostnames":
            return Optional.of(clazz.cast(enableDnsHostnames()));
        case "EnableDnsSupport":
            return Optional.of(clazz.cast(enableDnsSupport()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVpcAttributeResponse> {
        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is <code>true</code>
         * , instances in the VPC get DNS hostnames; otherwise, they do not.
         * </p>
         * 
         * @param enableDnsHostnames
         *        Indicates whether the instances launched in the VPC get DNS hostnames. If this attribute is
         *        <code>true</code>, instances in the VPC get DNS hostnames; otherwise, they do not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsHostnames(Boolean enableDnsHostnames);

        /**
         * <p>
         * Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the Amazon
         * DNS server resolves DNS hostnames for your instances to their corresponding IP addresses; otherwise, it does
         * not.
         * </p>
         * 
         * @param enableDnsSupport
         *        Indicates whether DNS resolution is enabled for the VPC. If this attribute is <code>true</code>, the
         *        Amazon DNS server resolves DNS hostnames for your instances to their corresponding IP addresses;
         *        otherwise, it does not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDnsSupport(Boolean enableDnsSupport);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private String vpcId;

        private Boolean enableDnsHostnames;

        private Boolean enableDnsSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcAttributeResponse model) {
            super(model);
            vpcId(model.vpcId);
            enableDnsHostnames(model.enableDnsHostnames);
            enableDnsSupport(model.enableDnsSupport);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEnableDnsHostnames() {
            return enableDnsHostnames;
        }

        @Override
        public final Builder enableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
            return this;
        }

        public final void setEnableDnsHostnames(Boolean enableDnsHostnames) {
            this.enableDnsHostnames = enableDnsHostnames;
        }

        public final Boolean getEnableDnsSupport() {
            return enableDnsSupport;
        }

        @Override
        public final Builder enableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
            return this;
        }

        public final void setEnableDnsSupport(Boolean enableDnsSupport) {
            this.enableDnsSupport = enableDnsSupport;
        }

        @Override
        public DescribeVpcAttributeResponse build() {
            return new DescribeVpcAttributeResponse(this);
        }
    }
}
