/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpnGateways.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnGatewaysResponse extends EC2Response implements
        ToCopyableBuilder<DescribeVpnGatewaysResponse.Builder, DescribeVpnGatewaysResponse> {
    private final List<VpnGateway> vpnGateways;

    private DescribeVpnGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.vpnGateways = builder.vpnGateways;
    }

    /**
     * <p>
     * Information about one or more virtual private gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more virtual private gateways.
     */
    public List<VpnGateway> vpnGateways() {
        return vpnGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpnGateways());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnGatewaysResponse)) {
            return false;
        }
        DescribeVpnGatewaysResponse other = (DescribeVpnGatewaysResponse) obj;
        return Objects.equals(vpnGateways(), other.vpnGateways());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeVpnGatewaysResponse").add("VpnGateways", vpnGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpnGateways":
            return Optional.of(clazz.cast(vpnGateways()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, DescribeVpnGatewaysResponse> {
        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(Collection<VpnGateway> vpnGateways);

        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * 
         * @param vpnGateways
         *        Information about one or more virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnGateways(VpnGateway... vpnGateways);

        /**
         * <p>
         * Information about one or more virtual private gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpnGateway>.Builder} avoiding the need to
         * create one manually via {@link List<VpnGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpnGateway>.Builder#build()} is called immediately and its
         * result is passed to {@link #vpnGateways(List<VpnGateway>)}.
         * 
         * @param vpnGateways
         *        a consumer that will call methods on {@link List<VpnGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpnGateways(List<VpnGateway>)
         */
        Builder vpnGateways(Consumer<VpnGateway.Builder>... vpnGateways);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<VpnGateway> vpnGateways;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnGatewaysResponse model) {
            super(model);
            vpnGateways(model.vpnGateways);
        }

        public final Collection<VpnGateway.Builder> getVpnGateways() {
            return vpnGateways != null ? vpnGateways.stream().map(VpnGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpnGateways(Collection<VpnGateway> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copy(vpnGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(VpnGateway... vpnGateways) {
            vpnGateways(Arrays.asList(vpnGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnGateways(Consumer<VpnGateway.Builder>... vpnGateways) {
            vpnGateways(Stream.of(vpnGateways).map(c -> VpnGateway.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpnGateways(Collection<VpnGateway.BuilderImpl> vpnGateways) {
            this.vpnGateways = VpnGatewayListCopier.copyFromBuilder(vpnGateways);
        }

        @Override
        public DescribeVpnGatewaysResponse build() {
            return new DescribeVpnGatewaysResponse(this);
        }
    }
}
