/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DisassociateVpcCidrBlockRequest extends EC2Request implements
        ToCopyableBuilder<DisassociateVpcCidrBlockRequest.Builder, DisassociateVpcCidrBlockRequest> {
    private final String associationId;

    private DisassociateVpcCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
    }

    /**
     * <p>
     * The association ID for the CIDR block.
     * </p>
     * 
     * @return The association ID for the CIDR block.
     */
    public String associationId() {
        return associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateVpcCidrBlockRequest)) {
            return false;
        }
        DisassociateVpcCidrBlockRequest other = (DisassociateVpcCidrBlockRequest) obj;
        return Objects.equals(associationId(), other.associationId());
    }

    @Override
    public String toString() {
        return ToString.builder("DisassociateVpcCidrBlockRequest").add("AssociationId", associationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, DisassociateVpcCidrBlockRequest> {
        /**
         * <p>
         * The association ID for the CIDR block.
         * </p>
         * 
         * @param associationId
         *        The association ID for the CIDR block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateVpcCidrBlockRequest model) {
            super(model);
            associationId(model.associationId);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DisassociateVpcCidrBlockRequest build() {
            return new DisassociateVpcCidrBlockRequest(this);
        }
    }
}
