/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskImageDetail implements ToCopyableBuilder<DiskImageDetail.Builder, DiskImageDetail> {
    private final Long bytes;

    private final String format;

    private final String importManifestUrl;

    private DiskImageDetail(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
    }

    /**
     * <p>
     * The size of the disk image, in GiB.
     * </p>
     * 
     * @return The size of the disk image, in GiB.
     */
    public Long bytes() {
        return bytes;
    }

    /**
     * <p>
     * The disk image format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The disk image format.
     * @see DiskImageFormat
     */
    public DiskImageFormat format() {
        return DiskImageFormat.fromValue(format);
    }

    /**
     * <p>
     * The disk image format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The disk image format.
     * @see DiskImageFormat
     */
    public String formatAsString() {
        return format;
    }

    /**
     * <p>
     * A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL. For
     * information about creating a presigned URL for an Amazon S3 object, read the
     * "Query String Request Authentication Alternative" section of the <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a>
     * topic in the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     * 
     * @return A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned
     *         URL. For information about creating a presigned URL for an Amazon S3 object, read the
     *         "Query String Request Authentication Alternative" section of the <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
     *         Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
     *         <p>
     *         For information about the import manifest referenced by this API action, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     */
    public String importManifestUrl() {
        return importManifestUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bytes());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importManifestUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDetail)) {
            return false;
        }
        DiskImageDetail other = (DiskImageDetail) obj;
        return Objects.equals(bytes(), other.bytes()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(importManifestUrl(), other.importManifestUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("DiskImageDetail").add("Bytes", bytes()).add("Format", formatAsString())
                .add("ImportManifestUrl", importManifestUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bytes":
            return Optional.of(clazz.cast(bytes()));
        case "Format":
            return Optional.of(clazz.cast(formatAsString()));
        case "ImportManifestUrl":
            return Optional.of(clazz.cast(importManifestUrl()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DiskImageDetail> {
        /**
         * <p>
         * The size of the disk image, in GiB.
         * </p>
         * 
         * @param bytes
         *        The size of the disk image, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytes(Long bytes);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param format
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param format
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder format(DiskImageFormat format);

        /**
         * <p>
         * A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3 presigned URL.
         * For information about creating a presigned URL for an Amazon S3 object, read the
         * "Query String Request Authentication Alternative" section of the <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
         * Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * <p>
         * For information about the import manifest referenced by this API action, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
         * </p>
         * 
         * @param importManifestUrl
         *        A presigned URL for the import manifest stored in Amazon S3 and presented here as an Amazon S3
         *        presigned URL. For information about creating a presigned URL for an Amazon S3 object, read the
         *        "Query String Request Authentication Alternative" section of the <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
         *        Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
         *        <p>
         *        For information about the import manifest referenced by this API action, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importManifestUrl(String importManifestUrl);
    }

    static final class BuilderImpl implements Builder {
        private Long bytes;

        private String format;

        private String importManifestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDetail model) {
            bytes(model.bytes);
            format(model.format);
            importManifestUrl(model.importManifestUrl);
        }

        public final Long getBytes() {
            return bytes;
        }

        @Override
        public final Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public final void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getImportManifestUrl() {
            return importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        @Override
        public DiskImageDetail build() {
            return new DiskImageDetail(this);
        }
    }
}
