/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the format and location for an instance export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ExportToS3Task implements ToCopyableBuilder<ExportToS3Task.Builder, ExportToS3Task> {
    private final String containerFormat;

    private final String diskImageFormat;

    private final String s3Bucket;

    private final String s3Key;

    private ExportToS3Task(BuilderImpl builder) {
        this.containerFormat = builder.containerFormat;
        this.diskImageFormat = builder.diskImageFormat;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(containerFormat);
    }

    /**
     * <p>
     * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image is
     * exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #containerFormat}
     * will return {@link ContainerFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #containerFormatAsString}.
     * </p>
     * 
     * @return The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
     *         image is exported.
     * @see ContainerFormat
     */
    public String containerFormatAsString() {
        return containerFormat;
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public DiskImageFormat diskImageFormat() {
        return DiskImageFormat.fromValue(diskImageFormat);
    }

    /**
     * <p>
     * The format for the exported image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #diskImageFormat}
     * will return {@link DiskImageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #diskImageFormatAsString}.
     * </p>
     * 
     * @return The format for the exported image.
     * @see DiskImageFormat
     */
    public String diskImageFormatAsString() {
        return diskImageFormat;
    }

    /**
     * <p>
     * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     * </p>
     * 
     * @return The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
     *         permissions to the AWS account <code>vm-import-export@amazon.com</code>.
     */
    public String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The encryption key for your S3 bucket.
     * </p>
     * 
     * @return The encryption key for your S3 bucket.
     */
    public String s3Key() {
        return s3Key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(diskImageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportToS3Task)) {
            return false;
        }
        ExportToS3Task other = (ExportToS3Task) obj;
        return Objects.equals(containerFormatAsString(), other.containerFormatAsString())
                && Objects.equals(diskImageFormatAsString(), other.diskImageFormatAsString())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key());
    }

    @Override
    public String toString() {
        return ToString.builder("ExportToS3Task").add("ContainerFormat", containerFormatAsString())
                .add("DiskImageFormat", diskImageFormatAsString()).add("S3Bucket", s3Bucket()).add("S3Key", s3Key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerFormat":
            return Optional.of(clazz.cast(containerFormatAsString()));
        case "DiskImageFormat":
            return Optional.of(clazz.cast(diskImageFormatAsString()));
        case "S3Bucket":
            return Optional.of(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.of(clazz.cast(s3Key()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ExportToS3Task> {
        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(String containerFormat);

        /**
         * <p>
         * The container format used to combine disk images with metadata (such as OVF). If absent, only the disk image
         * is exported.
         * </p>
         * 
         * @param containerFormat
         *        The container format used to combine disk images with metadata (such as OVF). If absent, only the disk
         *        image is exported.
         * @see ContainerFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContainerFormat
         */
        Builder containerFormat(ContainerFormat containerFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(String diskImageFormat);

        /**
         * <p>
         * The format for the exported image.
         * </p>
         * 
         * @param diskImageFormat
         *        The format for the exported image.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder diskImageFormat(DiskImageFormat diskImageFormat);

        /**
         * <p>
         * The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and READ_ACP
         * permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * </p>
         * 
         * @param s3Bucket
         *        The S3 bucket for the destination image. The destination bucket must exist and grant WRITE and
         *        READ_ACP permissions to the AWS account <code>vm-import-export@amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The encryption key for your S3 bucket.
         * </p>
         * 
         * @param s3Key
         *        The encryption key for your S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);
    }

    static final class BuilderImpl implements Builder {
        private String containerFormat;

        private String diskImageFormat;

        private String s3Bucket;

        private String s3Key;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportToS3Task model) {
            containerFormat(model.containerFormat);
            diskImageFormat(model.diskImageFormat);
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
        }

        public final String getContainerFormat() {
            return containerFormat;
        }

        @Override
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat.toString());
            return this;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        public final String getDiskImageFormat() {
            return diskImageFormat;
        }

        @Override
        public final Builder diskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
            return this;
        }

        @Override
        public final Builder diskImageFormat(DiskImageFormat diskImageFormat) {
            this.diskImageFormat(diskImageFormat.toString());
            return this;
        }

        public final void setDiskImageFormat(String diskImageFormat) {
            this.diskImageFormat = diskImageFormat;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3Key() {
            return s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public ExportToS3Task build() {
            return new ExportToS3Task(this);
        }
    }
}
