/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ImportImage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportImageRequest extends EC2Request implements ToCopyableBuilder<ImportImageRequest.Builder, ImportImageRequest> {
    private final String architecture;

    private final ClientData clientData;

    private final String clientToken;

    private final String description;

    private final List<ImageDiskContainer> diskContainers;

    private final String hypervisor;

    private final String licenseType;

    private final String platform;

    private final String roleName;

    private ImportImageRequest(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.hypervisor = builder.hypervisor;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The architecture of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>i386</code> | <code>x86_64</code>
     * </p>
     * 
     * @return The architecture of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>i386</code> | <code>x86_64</code>
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * The client-specific data.
     * </p>
     * 
     * @return The client-specific data.
     */
    public ClientData clientData() {
        return clientData;
    }

    /**
     * <p>
     * The token to enable idempotency for VM import requests.
     * </p>
     * 
     * @return The token to enable idempotency for VM import requests.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A description string for the import image task.
     * </p>
     * 
     * @return A description string for the import image task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Information about the disk containers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the disk containers.
     */
    public List<ImageDiskContainer> diskContainers() {
        return diskContainers;
    }

    /**
     * <p>
     * The target hypervisor platform.
     * </p>
     * <p>
     * Valid values: <code>xen</code>
     * </p>
     * 
     * @return The target hypervisor platform.</p>
     *         <p>
     *         Valid values: <code>xen</code>
     */
    public String hypervisor() {
        return hypervisor;
    }

    /**
     * <p>
     * The license type to be used for the Amazon Machine Image (AMI) after importing.
     * </p>
     * <p>
     * <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a third
     * party cloud like AWS. For more information, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     * >Prerequisites</a> in the VM Import/Export User Guide.
     * </p>
     * <p>
     * Valid values: <code>AWS</code> | <code>BYOL</code>
     * </p>
     * 
     * @return The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
     *         <p>
     *         <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a
     *         third party cloud like AWS. For more information, see <a href=
     *         "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
     *         >Prerequisites</a> in the VM Import/Export User Guide.
     *         </p>
     *         <p>
     *         Valid values: <code>AWS</code> | <code>BYOL</code>
     */
    public String licenseType() {
        return licenseType;
    }

    /**
     * <p>
     * The operating system of the virtual machine.
     * </p>
     * <p>
     * Valid values: <code>Windows</code> | <code>Linux</code>
     * </p>
     * 
     * @return The operating system of the virtual machine.</p>
     *         <p>
     *         Valid values: <code>Windows</code> | <code>Linux</code>
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The name of the role to use when not using the default role, 'vmimport'.
     * </p>
     * 
     * @return The name of the role to use when not using the default role, 'vmimport'.
     */
    public String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(architecture());
        hashCode = 31 * hashCode + Objects.hashCode(clientData());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(diskContainers());
        hashCode = 31 * hashCode + Objects.hashCode(hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest) obj;
        return Objects.equals(architecture(), other.architecture()) && Objects.equals(clientData(), other.clientData())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(diskContainers(), other.diskContainers()) && Objects.equals(hypervisor(), other.hypervisor())
                && Objects.equals(licenseType(), other.licenseType()) && Objects.equals(platform(), other.platform())
                && Objects.equals(roleName(), other.roleName());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportImageRequest").add("Architecture", architecture()).add("ClientData", clientData())
                .add("ClientToken", clientToken()).add("Description", description()).add("DiskContainers", diskContainers())
                .add("Hypervisor", hypervisor()).add("LicenseType", licenseType()).add("Platform", platform())
                .add("RoleName", roleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Architecture":
            return Optional.of(clazz.cast(architecture()));
        case "ClientData":
            return Optional.of(clazz.cast(clientData()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DiskContainers":
            return Optional.of(clazz.cast(diskContainers()));
        case "Hypervisor":
            return Optional.of(clazz.cast(hypervisor()));
        case "LicenseType":
            return Optional.of(clazz.cast(licenseType()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "RoleName":
            return Optional.of(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ImportImageRequest> {
        /**
         * <p>
         * The architecture of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>i386</code> | <code>x86_64</code>
         * </p>
         * 
         * @param architecture
         *        The architecture of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>i386</code> | <code>x86_64</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * 
         * @param clientData
         *        The client-specific data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientData(ClientData clientData);

        /**
         * <p>
         * The client-specific data.
         * </p>
         * This is a convenience that creates an instance of the {@link ClientData.Builder} avoiding the need to create
         * one manually via {@link ClientData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClientData.Builder#build()} is called immediately and its result
         * is passed to {@link #clientData(ClientData)}.
         * 
         * @param clientData
         *        a consumer that will call methods on {@link ClientData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientData(ClientData)
         */
        default Builder clientData(Consumer<ClientData.Builder> clientData) {
            return clientData(ClientData.builder().apply(clientData).build());
        }

        /**
         * <p>
         * The token to enable idempotency for VM import requests.
         * </p>
         * 
         * @param clientToken
         *        The token to enable idempotency for VM import requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A description string for the import image task.
         * </p>
         * 
         * @param description
         *        A description string for the import image task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(Collection<ImageDiskContainer> diskContainers);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * 
         * @param diskContainers
         *        Information about the disk containers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskContainers(ImageDiskContainer... diskContainers);

        /**
         * <p>
         * Information about the disk containers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImageDiskContainer>.Builder} avoiding the
         * need to create one manually via {@link List<ImageDiskContainer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImageDiskContainer>.Builder#build()} is called immediately
         * and its result is passed to {@link #diskContainers(List<ImageDiskContainer>)}.
         * 
         * @param diskContainers
         *        a consumer that will call methods on {@link List<ImageDiskContainer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskContainers(List<ImageDiskContainer>)
         */
        Builder diskContainers(Consumer<ImageDiskContainer.Builder>... diskContainers);

        /**
         * <p>
         * The target hypervisor platform.
         * </p>
         * <p>
         * Valid values: <code>xen</code>
         * </p>
         * 
         * @param hypervisor
         *        The target hypervisor platform.</p>
         *        <p>
         *        Valid values: <code>xen</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(String hypervisor);

        /**
         * <p>
         * The license type to be used for the Amazon Machine Image (AMI) after importing.
         * </p>
         * <p>
         * <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in a third
         * party cloud like AWS. For more information, see <a
         * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         * >Prerequisites</a> in the VM Import/Export User Guide.
         * </p>
         * <p>
         * Valid values: <code>AWS</code> | <code>BYOL</code>
         * </p>
         * 
         * @param licenseType
         *        The license type to be used for the Amazon Machine Image (AMI) after importing.</p>
         *        <p>
         *        <b>Note:</b> You may only use BYOL if you have existing licenses with rights to use these licenses in
         *        a third party cloud like AWS. For more information, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image"
         *        >Prerequisites</a> in the VM Import/Export User Guide.
         *        </p>
         *        <p>
         *        Valid values: <code>AWS</code> | <code>BYOL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The operating system of the virtual machine.
         * </p>
         * <p>
         * Valid values: <code>Windows</code> | <code>Linux</code>
         * </p>
         * 
         * @param platform
         *        The operating system of the virtual machine.</p>
         *        <p>
         *        Valid values: <code>Windows</code> | <code>Linux</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The name of the role to use when not using the default role, 'vmimport'.
         * </p>
         * 
         * @param roleName
         *        The name of the role to use when not using the default role, 'vmimport'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String architecture;

        private ClientData clientData;

        private String clientToken;

        private String description;

        private List<ImageDiskContainer> diskContainers;

        private String hypervisor;

        private String licenseType;

        private String platform;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            super(model);
            architecture(model.architecture);
            clientData(model.clientData);
            clientToken(model.clientToken);
            description(model.description);
            diskContainers(model.diskContainers);
            hypervisor(model.hypervisor);
            licenseType(model.licenseType);
            platform(model.platform);
            roleName(model.roleName);
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final ClientData.Builder getClientData() {
            return clientData != null ? clientData.toBuilder() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ImageDiskContainer.Builder> getDiskContainers() {
            return diskContainers != null ? diskContainers.stream().map(ImageDiskContainer::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer... diskContainers) {
            diskContainers(Arrays.asList(diskContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(Consumer<ImageDiskContainer.Builder>... diskContainers) {
            diskContainers(Stream.of(diskContainers).map(c -> ImageDiskContainer.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer.BuilderImpl> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copyFromBuilder(diskContainers);
        }

        public final String getHypervisor() {
            return hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }
    }
}
