/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAttribute implements ToCopyableBuilder<InstanceAttribute.Builder, InstanceAttribute> {
    private final List<GroupIdentifier> groups;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final Boolean disableApiTermination;

    private final Boolean enaSupport;

    private final Boolean ebsOptimized;

    private final String instanceId;

    private final String instanceInitiatedShutdownBehavior;

    private final String instanceType;

    private final String kernelId;

    private final List<ProductCode> productCodes;

    private final String ramdiskId;

    private final String rootDeviceName;

    private final Boolean sourceDestCheck;

    private final String sriovNetSupport;

    private final String userData;

    private InstanceAttribute(BuilderImpl builder) {
        this.groups = builder.groups;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * The security groups associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security groups associated with the instance.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The block device mapping of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The block device mapping of the instance.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or API;
     * otherwise, you can.
     * </p>
     * 
     * @return If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI,
     *         or API; otherwise, you can.
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for Amazon EBS I/O.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     */
    public String instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The device name of the root device volume (for example, <code>/dev/sda1</code>).
     * </p>
     * 
     * @return The device name of the root device volume (for example, <code>/dev/sda1</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled. A value of <code>true</code> means that checking is
     * enabled, and <code>false</code> means that checking is disabled. This value must be <code>false</code> for a NAT
     * instance to perform NAT.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled. A value of <code>true</code> means that
     *         checking is enabled, and <code>false</code> means that checking is disabled. This value must be
     *         <code>false</code> for a NAT instance to perform NAT.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The user data.
     * </p>
     * 
     * @return The user data.
     */
    public String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groups());
        hashCode = 31 * hashCode + Objects.hashCode(blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(ramdiskId());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(userData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAttribute)) {
            return false;
        }
        InstanceAttribute other = (InstanceAttribute) obj;
        return Objects.equals(groups(), other.groups()) && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(disableApiTermination(), other.disableApiTermination())
                && Objects.equals(enaSupport(), other.enaSupport()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(kernelId(), other.kernelId())
                && Objects.equals(productCodes(), other.productCodes()) && Objects.equals(ramdiskId(), other.ramdiskId())
                && Objects.equals(rootDeviceName(), other.rootDeviceName())
                && Objects.equals(sourceDestCheck(), other.sourceDestCheck())
                && Objects.equals(sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(userData(), other.userData());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceAttribute").add("Groups", groups()).add("BlockDeviceMappings", blockDeviceMappings())
                .add("DisableApiTermination", disableApiTermination()).add("EnaSupport", enaSupport())
                .add("EbsOptimized", ebsOptimized()).add("InstanceId", instanceId())
                .add("InstanceInitiatedShutdownBehavior", instanceInitiatedShutdownBehavior())
                .add("InstanceType", instanceType()).add("KernelId", kernelId()).add("ProductCodes", productCodes())
                .add("RamdiskId", ramdiskId()).add("RootDeviceName", rootDeviceName()).add("SourceDestCheck", sourceDestCheck())
                .add("SriovNetSupport", sriovNetSupport()).add("UserData", userData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Groups":
            return Optional.of(clazz.cast(groups()));
        case "BlockDeviceMappings":
            return Optional.of(clazz.cast(blockDeviceMappings()));
        case "DisableApiTermination":
            return Optional.of(clazz.cast(disableApiTermination()));
        case "EnaSupport":
            return Optional.of(clazz.cast(enaSupport()));
        case "EbsOptimized":
            return Optional.of(clazz.cast(ebsOptimized()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceInitiatedShutdownBehavior":
            return Optional.of(clazz.cast(instanceInitiatedShutdownBehavior()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "KernelId":
            return Optional.of(clazz.cast(kernelId()));
        case "ProductCodes":
            return Optional.of(clazz.cast(productCodes()));
        case "RamdiskId":
            return Optional.of(clazz.cast(ramdiskId()));
        case "RootDeviceName":
            return Optional.of(clazz.cast(rootDeviceName()));
        case "SourceDestCheck":
            return Optional.of(clazz.cast(sourceDestCheck()));
        case "SriovNetSupport":
            return Optional.of(clazz.cast(sriovNetSupport()));
        case "UserData":
            return Optional.of(clazz.cast(userData()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAttribute> {
        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupIdentifier>.Builder} avoiding the need
         * to create one manually via {@link List<GroupIdentifier>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupIdentifier>.Builder#build()} is called immediately and
         * its result is passed to {@link #groups(List<GroupIdentifier>)}.
         * 
         * @param groups
         *        a consumer that will call methods on {@link List<GroupIdentifier>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groups(List<GroupIdentifier>)
         */
        Builder groups(Consumer<GroupIdentifier.Builder>... groups);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceBlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceBlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceBlockDeviceMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<InstanceBlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<InstanceBlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<InstanceBlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or
         * API; otherwise, you can.
         * </p>
         * 
         * @param disableApiTermination
         *        If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console,
         *        CLI, or API; otherwise, you can.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Indicates whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * Indicates whether the instance is optimized for Amazon EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for Amazon EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProductCode>.Builder} avoiding the need to
         * create one manually via {@link List<ProductCode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProductCode>.Builder#build()} is called immediately and its
         * result is passed to {@link #productCodes(List<ProductCode>)}.
         * 
         * @param productCodes
         *        a consumer that will call methods on {@link List<ProductCode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #productCodes(List<ProductCode>)
         */
        Builder productCodes(Consumer<ProductCode.Builder>... productCodes);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The device name of the root device volume (for example, <code>/dev/sda1</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled. A value of <code>true</code> means that checking is
         * enabled, and <code>false</code> means that checking is disabled. This value must be <code>false</code> for a
         * NAT instance to perform NAT.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled. A value of <code>true</code> means that
         *        checking is enabled, and <code>false</code> means that checking is disabled. This value must be
         *        <code>false</code> for a NAT instance to perform NAT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The user data.
         * </p>
         * 
         * @param userData
         *        The user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings;

        private Boolean disableApiTermination;

        private Boolean enaSupport;

        private Boolean ebsOptimized;

        private String instanceId;

        private String instanceInitiatedShutdownBehavior;

        private String instanceType;

        private String kernelId;

        private List<ProductCode> productCodes;

        private String ramdiskId;

        private String rootDeviceName;

        private Boolean sourceDestCheck;

        private String sriovNetSupport;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAttribute model) {
            groups(model.groups);
            blockDeviceMappings(model.blockDeviceMappings);
            disableApiTermination(model.disableApiTermination);
            enaSupport(model.enaSupport);
            ebsOptimized(model.ebsOptimized);
            instanceId(model.instanceId);
            instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            instanceType(model.instanceType);
            kernelId(model.kernelId);
            productCodes(model.productCodes);
            ramdiskId(model.ramdiskId);
            rootDeviceName(model.rootDeviceName);
            sourceDestCheck(model.sourceDestCheck);
            sriovNetSupport(model.sriovNetSupport);
            userData(model.userData);
        }

        public final Collection<GroupIdentifier.Builder> getGroups() {
            return groups != null ? groups.stream().map(GroupIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder>... groups) {
            groups(Stream.of(groups).map(c -> GroupIdentifier.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        public final Collection<InstanceBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            return blockDeviceMappings != null ? blockDeviceMappings.stream().map(InstanceBlockDeviceMapping::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> InstanceBlockDeviceMapping.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Collection<ProductCode.Builder> getProductCodes() {
            return productCodes != null ? productCodes.stream().map(ProductCode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(Consumer<ProductCode.Builder>... productCodes) {
            productCodes(Stream.of(productCodes).map(c -> ProductCode.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode.BuilderImpl> productCodes) {
            this.productCodes = ProductCodeListCopier.copyFromBuilder(productCodes);
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public InstanceAttribute build() {
            return new InstanceAttribute(this);
        }
    }
}
