/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceBlockDeviceMapping implements
        ToCopyableBuilder<InstanceBlockDeviceMapping.Builder, InstanceBlockDeviceMapping> {
    private final String deviceName;

    private final EbsInstanceBlockDevice ebs;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
    }

    /**
     * <p>
     * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public EbsInstanceBlockDevice ebs() {
        return ebs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceBlockDeviceMapping").add("DeviceName", deviceName()).add("Ebs", ebs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.of(clazz.cast(ebs()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        /**
         * <p>
         * The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsInstanceBlockDevice ebs);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsInstanceBlockDevice.Builder} avoiding the
         * need to create one manually via {@link EbsInstanceBlockDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsInstanceBlockDevice.Builder#build()} is called immediately and
         * its result is passed to {@link #ebs(EbsInstanceBlockDevice)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsInstanceBlockDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsInstanceBlockDevice)
         */
        default Builder ebs(Consumer<EbsInstanceBlockDevice.Builder> ebs) {
            return ebs(EbsInstanceBlockDevice.builder().apply(ebs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsInstanceBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }
    }
}
