/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current state of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceState implements ToCopyableBuilder<InstanceState.Builder, InstanceState> {
    private final Integer code;

    private final String name;

    private InstanceState(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * <p>
     * The low byte represents the state. The high byte is an opaque internal value and should be ignored.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>0</code> : <code>pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>16</code> : <code>running</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>32</code> : <code>shutting-down</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>48</code> : <code>terminated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>64</code> : <code>stopping</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>80</code> : <code>stopped</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The low byte represents the state. The high byte is an opaque internal value and should be ignored.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>0</code> : <code>pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>16</code> : <code>running</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>32</code> : <code>shutting-down</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>48</code> : <code>terminated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>64</code> : <code>stopping</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>80</code> : <code>stopped</code>
     *         </p>
     *         </li>
     */
    public Integer code() {
        return code;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link InstanceStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceStateName
     */
    public InstanceStateName name() {
        return InstanceStateName.fromValue(name);
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link InstanceStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceStateName
     */
    public String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(nameAsString(), other.nameAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("InstanceState").add("Code", code()).add("Name", nameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.of(clazz.cast(code()));
        case "Name":
            return Optional.of(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceState> {
        /**
         * <p>
         * The low byte represents the state. The high byte is an opaque internal value and should be ignored.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>0</code> : <code>pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>16</code> : <code>running</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>32</code> : <code>shutting-down</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>48</code> : <code>terminated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>64</code> : <code>stopping</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>80</code> : <code>stopped</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        The low byte represents the state. The high byte is an opaque internal value and should be
         *        ignored.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>0</code> : <code>pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>16</code> : <code>running</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>32</code> : <code>shutting-down</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>48</code> : <code>terminated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>64</code> : <code>stopping</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>80</code> : <code>stopped</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param name
         *        The current state of the instance.
         * @see InstanceStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStateName
         */
        Builder name(String name);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param name
         *        The current state of the instance.
         * @see InstanceStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStateName
         */
        Builder name(InstanceStateName name);
    }

    static final class BuilderImpl implements Builder {
        private Integer code;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            code(model.code);
            name(model.name);
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(InstanceStateName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public InstanceState build() {
            return new InstanceState(this);
        }
    }
}
