/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVpcPeeringConnectionOptionsRequest extends EC2Request implements
        ToCopyableBuilder<ModifyVpcPeeringConnectionOptionsRequest.Builder, ModifyVpcPeeringConnectionOptionsRequest> {
    private final PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

    private final PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

    private final String vpcPeeringConnectionId;

    private ModifyVpcPeeringConnectionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The VPC peering connection options for the accepter VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the accepter VPC.
     */
    public PeeringConnectionOptionsRequest accepterPeeringConnectionOptions() {
        return accepterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The VPC peering connection options for the requester VPC.
     * </p>
     * 
     * @return The VPC peering connection options for the requester VPC.
     */
    public PeeringConnectionOptionsRequest requesterPeeringConnectionOptions() {
        return requesterPeeringConnectionOptions;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accepterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(requesterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsRequest other = (ModifyVpcPeeringConnectionOptionsRequest) obj;
        return Objects.equals(accepterPeeringConnectionOptions(), other.accepterPeeringConnectionOptions())
                && Objects.equals(requesterPeeringConnectionOptions(), other.requesterPeeringConnectionOptions())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    @Override
    public String toString() {
        return ToString.builder("ModifyVpcPeeringConnectionOptionsRequest")
                .add("AccepterPeeringConnectionOptions", accepterPeeringConnectionOptions())
                .add("RequesterPeeringConnectionOptions", requesterPeeringConnectionOptions())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccepterPeeringConnectionOptions":
            return Optional.of(clazz.cast(accepterPeeringConnectionOptions()));
        case "RequesterPeeringConnectionOptions":
            return Optional.of(clazz.cast(requesterPeeringConnectionOptions()));
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsRequest> {
        /**
         * <p>
         * The VPC peering connection options for the accepter VPC.
         * </p>
         * 
         * @param accepterPeeringConnectionOptions
         *        The VPC peering connection options for the accepter VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions);

        /**
         * <p>
         * The VPC peering connection options for the accepter VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringConnectionOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link PeeringConnectionOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest)}.
         * 
         * @param accepterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest)
         */
        default Builder accepterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptionsRequest.Builder> accepterPeeringConnectionOptions) {
            return accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest.builder()
                    .apply(accepterPeeringConnectionOptions).build());
        }

        /**
         * <p>
         * The VPC peering connection options for the requester VPC.
         * </p>
         * 
         * @param requesterPeeringConnectionOptions
         *        The VPC peering connection options for the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions);

        /**
         * <p>
         * The VPC peering connection options for the requester VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link PeeringConnectionOptionsRequest.Builder}
         * avoiding the need to create one manually via {@link PeeringConnectionOptionsRequest#builder()}.
         *
         * When the {@link Consumer} completes, {@link PeeringConnectionOptionsRequest.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest)}.
         * 
         * @param requesterPeeringConnectionOptions
         *        a consumer that will call methods on {@link PeeringConnectionOptionsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest)
         */
        default Builder requesterPeeringConnectionOptions(
                Consumer<PeeringConnectionOptionsRequest.Builder> requesterPeeringConnectionOptions) {
            return requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest.builder()
                    .apply(requesterPeeringConnectionOptions).build());
        }

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;

        private PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsRequest model) {
            super(model);
            accepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            requesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final PeeringConnectionOptionsRequest.Builder getAccepterPeeringConnectionOptions() {
            return accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(
                PeeringConnectionOptionsRequest.BuilderImpl accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions
                    .build() : null;
        }

        public final PeeringConnectionOptionsRequest.Builder getRequesterPeeringConnectionOptions() {
            return requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(
                PeeringConnectionOptionsRequest.BuilderImpl requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions
                    .build() : null;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsRequest build() {
            return new ModifyVpcPeeringConnectionOptionsRequest(this);
        }
    }
}
