/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of MonitorInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class MonitorInstancesResponse extends EC2Response implements
        ToCopyableBuilder<MonitorInstancesResponse.Builder, MonitorInstancesResponse> {
    private final List<InstanceMonitoring> instanceMonitorings;

    private MonitorInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceMonitorings = builder.instanceMonitorings;
    }

    /**
     * <p>
     * The monitoring information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The monitoring information.
     */
    public List<InstanceMonitoring> instanceMonitorings() {
        return instanceMonitorings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceMonitorings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorInstancesResponse)) {
            return false;
        }
        MonitorInstancesResponse other = (MonitorInstancesResponse) obj;
        return Objects.equals(instanceMonitorings(), other.instanceMonitorings());
    }

    @Override
    public String toString() {
        return ToString.builder("MonitorInstancesResponse").add("InstanceMonitorings", instanceMonitorings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceMonitorings":
            return Optional.of(clazz.cast(instanceMonitorings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, MonitorInstancesResponse> {
        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings);

        /**
         * <p>
         * The monitoring information.
         * </p>
         * 
         * @param instanceMonitorings
         *        The monitoring information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings);

        /**
         * <p>
         * The monitoring information.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceMonitoring>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceMonitoring>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceMonitoring>.Builder#build()} is called immediately
         * and its result is passed to {@link #instanceMonitorings(List<InstanceMonitoring>)}.
         * 
         * @param instanceMonitorings
         *        a consumer that will call methods on {@link List<InstanceMonitoring>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMonitorings(List<InstanceMonitoring>)
         */
        Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder>... instanceMonitorings);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<InstanceMonitoring> instanceMonitorings;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorInstancesResponse model) {
            super(model);
            instanceMonitorings(model.instanceMonitorings);
        }

        public final Collection<InstanceMonitoring.Builder> getInstanceMonitorings() {
            return instanceMonitorings != null ? instanceMonitorings.stream().map(InstanceMonitoring::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceMonitorings(Collection<InstanceMonitoring> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copy(instanceMonitorings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(InstanceMonitoring... instanceMonitorings) {
            instanceMonitorings(Arrays.asList(instanceMonitorings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceMonitorings(Consumer<InstanceMonitoring.Builder>... instanceMonitorings) {
            instanceMonitorings(Stream.of(instanceMonitorings).map(c -> InstanceMonitoring.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceMonitorings(Collection<InstanceMonitoring.BuilderImpl> instanceMonitorings) {
            this.instanceMonitorings = InstanceMonitoringListCopier.copyFromBuilder(instanceMonitorings);
        }

        @Override
        public MonitorInstancesResponse build() {
            return new MonitorInstancesResponse(this);
        }
    }
}
