/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes association information for an Elastic IP address (IPv4 only).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkInterfaceAssociation implements
        ToCopyableBuilder<NetworkInterfaceAssociation.Builder, NetworkInterfaceAssociation> {
    private final String allocationId;

    private final String associationId;

    private final String ipOwnerId;

    private final String publicDnsName;

    private final String publicIp;

    private NetworkInterfaceAssociation(BuilderImpl builder) {
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.ipOwnerId = builder.ipOwnerId;
        this.publicDnsName = builder.publicDnsName;
        this.publicIp = builder.publicIp;
    }

    /**
     * <p>
     * The allocation ID.
     * </p>
     * 
     * @return The allocation ID.
     */
    public String allocationId() {
        return allocationId;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The ID of the Elastic IP address owner.
     * </p>
     * 
     * @return The ID of the Elastic IP address owner.
     */
    public String ipOwnerId() {
        return ipOwnerId;
    }

    /**
     * <p>
     * The public DNS name.
     * </p>
     * 
     * @return The public DNS name.
     */
    public String publicDnsName() {
        return publicDnsName;
    }

    /**
     * <p>
     * The address of the Elastic IP address bound to the network interface.
     * </p>
     * 
     * @return The address of the Elastic IP address bound to the network interface.
     */
    public String publicIp() {
        return publicIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(ipOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(publicDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAssociation)) {
            return false;
        }
        NetworkInterfaceAssociation other = (NetworkInterfaceAssociation) obj;
        return Objects.equals(allocationId(), other.allocationId()) && Objects.equals(associationId(), other.associationId())
                && Objects.equals(ipOwnerId(), other.ipOwnerId()) && Objects.equals(publicDnsName(), other.publicDnsName())
                && Objects.equals(publicIp(), other.publicIp());
    }

    @Override
    public String toString() {
        return ToString.builder("NetworkInterfaceAssociation").add("AllocationId", allocationId())
                .add("AssociationId", associationId()).add("IpOwnerId", ipOwnerId()).add("PublicDnsName", publicDnsName())
                .add("PublicIp", publicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocationId":
            return Optional.of(clazz.cast(allocationId()));
        case "AssociationId":
            return Optional.of(clazz.cast(associationId()));
        case "IpOwnerId":
            return Optional.of(clazz.cast(ipOwnerId()));
        case "PublicDnsName":
            return Optional.of(clazz.cast(publicDnsName()));
        case "PublicIp":
            return Optional.of(clazz.cast(publicIp()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkInterfaceAssociation> {
        /**
         * <p>
         * The allocation ID.
         * </p>
         * 
         * @param allocationId
         *        The allocation ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationId(String allocationId);

        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The ID of the Elastic IP address owner.
         * </p>
         * 
         * @param ipOwnerId
         *        The ID of the Elastic IP address owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipOwnerId(String ipOwnerId);

        /**
         * <p>
         * The public DNS name.
         * </p>
         * 
         * @param publicDnsName
         *        The public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDnsName(String publicDnsName);

        /**
         * <p>
         * The address of the Elastic IP address bound to the network interface.
         * </p>
         * 
         * @param publicIp
         *        The address of the Elastic IP address bound to the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);
    }

    static final class BuilderImpl implements Builder {
        private String allocationId;

        private String associationId;

        private String ipOwnerId;

        private String publicDnsName;

        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAssociation model) {
            allocationId(model.allocationId);
            associationId(model.associationId);
            ipOwnerId(model.ipOwnerId);
            publicDnsName(model.publicDnsName);
            publicIp(model.publicIp);
        }

        public final String getAllocationId() {
            return allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getIpOwnerId() {
            return ipOwnerId;
        }

        @Override
        public final Builder ipOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
            return this;
        }

        public final void setIpOwnerId(String ipOwnerId) {
            this.ipOwnerId = ipOwnerId;
        }

        public final String getPublicDnsName() {
            return publicDnsName;
        }

        @Override
        public final Builder publicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
            return this;
        }

        public final void setPublicDnsName(String publicDnsName) {
            this.publicDnsName = publicDnsName;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public NetworkInterfaceAssociation build() {
            return new NetworkInterfaceAssociation(this);
        }
    }
}
