/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for RequestSpotInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RequestSpotInstancesRequest extends EC2Request implements
        ToCopyableBuilder<RequestSpotInstancesRequest.Builder, RequestSpotInstancesRequest> {
    private final String availabilityZoneGroup;

    private final Integer blockDurationMinutes;

    private final String clientToken;

    private final Integer instanceCount;

    private final String launchGroup;

    private final LaunchSpecification launchSpecification;

    private final String spotPrice;

    private final String type;

    private final Instant validFrom;

    private final Instant validUntil;

    private final String instanceInterruptionBehavior;

    private RequestSpotInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZoneGroup = builder.availabilityZoneGroup;
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.clientToken = builder.clientToken;
        this.instanceCount = builder.instanceCount;
        this.launchGroup = builder.launchGroup;
        this.launchSpecification = builder.launchSpecification;
        this.spotPrice = builder.spotPrice;
        this.type = builder.type;
        this.validFrom = builder.validFrom;
        this.validUntil = builder.validUntil;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
    }

    /**
     * <p>
     * The user-specified name for a logical grouping of bids.
     * </p>
     * <p>
     * When you specify an Availability Zone group in a Spot Instance request, all Spot instances in the request are
     * launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice of
     * Availability Zone is not. The group applies only to bids for Spot Instances of the same instance type. Any
     * additional Spot instance requests that are specified with the same Availability Zone group name are launched in
     * that same Availability Zone, as long as at least one instance from the group is still active.
     * </p>
     * <p>
     * If there is no active instance running in the Availability Zone group that you specify for a new Spot instance
     * request (all instances are terminated, the bid is expired, or the bid falls below current market), then Amazon
     * EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently, the subsequent
     * set of Spot instances could be placed in a different zone from the original request, even if you specified the
     * same Availability Zone group.
     * </p>
     * <p>
     * Default: Instances are launched in any available Availability Zone.
     * </p>
     * 
     * @return The user-specified name for a logical grouping of bids.</p>
     *         <p>
     *         When you specify an Availability Zone group in a Spot Instance request, all Spot instances in the request
     *         are launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the
     *         choice of Availability Zone is not. The group applies only to bids for Spot Instances of the same
     *         instance type. Any additional Spot instance requests that are specified with the same Availability Zone
     *         group name are launched in that same Availability Zone, as long as at least one instance from the group
     *         is still active.
     *         </p>
     *         <p>
     *         If there is no active instance running in the Availability Zone group that you specify for a new Spot
     *         instance request (all instances are terminated, the bid is expired, or the bid falls below current
     *         market), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met.
     *         Consequently, the subsequent set of Spot instances could be placed in a different zone from the original
     *         request, even if you specified the same Availability Zone group.
     *         </p>
     *         <p>
     *         Default: Instances are launched in any available Availability Zone.
     */
    public String availabilityZoneGroup() {
        return availabilityZoneGroup;
    }

    /**
     * <p>
     * The required duration for the Spot instances (also known as Spot blocks), in minutes. This value must be a
     * multiple of 60 (60, 120, 180, 240, 300, or 360).
     * </p>
     * <p>
     * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration
     * period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice, which
     * gives the instance a two-minute warning before it terminates.
     * </p>
     * <p>
     * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
     * </p>
     * 
     * @return The required duration for the Spot instances (also known as Spot blocks), in minutes. This value must be
     *         a multiple of 60 (60, 120, 180, 240, 300, or 360).</p>
     *         <p>
     *         The duration period starts as soon as your Spot instance receives its instance ID. At the end of the
     *         duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance
     *         termination notice, which gives the instance a two-minute warning before it terminates.
     *         </p>
     *         <p>
     *         Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
     */
    public Integer blockDurationMinutes() {
        return blockDurationMinutes;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     * information, see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How
     * to Ensure Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
     *         Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The maximum number of Spot instances to launch.
     * </p>
     * <p>
     * Default: 1
     * </p>
     * 
     * @return The maximum number of Spot instances to launch.</p>
     *         <p>
     *         Default: 1
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance launch group. Launch groups are Spot instances that launch together and terminate together.
     * </p>
     * <p>
     * Default: Instances are launched and terminated individually
     * </p>
     * 
     * @return The instance launch group. Launch groups are Spot instances that launch together and terminate
     *         together.</p>
     *         <p>
     *         Default: Instances are launched and terminated individually
     */
    public String launchGroup() {
        return launchGroup;
    }

    /**
     * <p>
     * The launch specification.
     * </p>
     * 
     * @return The launch specification.
     */
    public LaunchSpecification launchSpecification() {
        return launchSpecification;
    }

    /**
     * <p>
     * The maximum hourly price (bid) for any Spot instance launched to fulfill the request.
     * </p>
     * 
     * @return The maximum hourly price (bid) for any Spot instance launched to fulfill the request.
     */
    public String spotPrice() {
        return spotPrice;
    }

    /**
     * <p>
     * The Spot instance request type.
     * </p>
     * <p>
     * Default: <code>one-time</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SpotInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Spot instance request type.</p>
     *         <p>
     *         Default: <code>one-time</code>
     * @see SpotInstanceType
     */
    public SpotInstanceType type() {
        return SpotInstanceType.fromValue(type);
    }

    /**
     * <p>
     * The Spot instance request type.
     * </p>
     * <p>
     * Default: <code>one-time</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SpotInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The Spot instance request type.</p>
     *         <p>
     *         Default: <code>one-time</code>
     * @see SpotInstanceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The start date of the request. If this is a one-time request, the request becomes active at this date and time
     * and remains active until all instances launch, the request expires, or the request is canceled. If the request is
     * persistent, the request becomes active at this date and time and remains active until it expires or is canceled.
     * </p>
     * <p>
     * Default: The request is effective indefinitely.
     * </p>
     * 
     * @return The start date of the request. If this is a one-time request, the request becomes active at this date and
     *         time and remains active until all instances launch, the request expires, or the request is canceled. If
     *         the request is persistent, the request becomes active at this date and time and remains active until it
     *         expires or is canceled.</p>
     *         <p>
     *         Default: The request is effective indefinitely.
     */
    public Instant validFrom() {
        return validFrom;
    }

    /**
     * <p>
     * The end date of the request. If this is a one-time request, the request remains active until all instances
     * launch, the request is canceled, or this date is reached. If the request is persistent, it remains active until
     * it is canceled or this date and time is reached.
     * </p>
     * <p>
     * Default: The request is effective indefinitely.
     * </p>
     * 
     * @return The end date of the request. If this is a one-time request, the request remains active until all
     *         instances launch, the request is canceled, or this date is reached. If the request is persistent, it
     *         remains active until it is canceled or this date and time is reached.</p>
     *         <p>
     *         Default: The request is effective indefinitely.
     */
    public Instant validUntil() {
        return validUntil;
    }

    /**
     * <p>
     * Indicates whether a Spot instance stops or terminates when it is interrupted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether a Spot instance stops or terminates when it is interrupted.
     * @see InstanceInterruptionBehavior
     */
    public InstanceInterruptionBehavior instanceInterruptionBehavior() {
        return InstanceInterruptionBehavior.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * Indicates whether a Spot instance stops or terminates when it is interrupted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehavior#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return Indicates whether a Spot instance stops or terminates when it is interrupted.
     * @see InstanceInterruptionBehavior
     */
    public String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneGroup());
        hashCode = 31 * hashCode + Objects.hashCode(blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(launchGroup());
        hashCode = 31 * hashCode + Objects.hashCode(launchSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(spotPrice());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validFrom());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSpotInstancesRequest)) {
            return false;
        }
        RequestSpotInstancesRequest other = (RequestSpotInstancesRequest) obj;
        return Objects.equals(availabilityZoneGroup(), other.availabilityZoneGroup())
                && Objects.equals(blockDurationMinutes(), other.blockDurationMinutes())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(launchGroup(), other.launchGroup())
                && Objects.equals(launchSpecification(), other.launchSpecification())
                && Objects.equals(spotPrice(), other.spotPrice()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(validFrom(), other.validFrom()) && Objects.equals(validUntil(), other.validUntil())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("RequestSpotInstancesRequest").add("AvailabilityZoneGroup", availabilityZoneGroup())
                .add("BlockDurationMinutes", blockDurationMinutes()).add("ClientToken", clientToken())
                .add("InstanceCount", instanceCount()).add("LaunchGroup", launchGroup())
                .add("LaunchSpecification", launchSpecification()).add("SpotPrice", spotPrice()).add("Type", typeAsString())
                .add("ValidFrom", validFrom()).add("ValidUntil", validUntil())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZoneGroup":
            return Optional.of(clazz.cast(availabilityZoneGroup()));
        case "BlockDurationMinutes":
            return Optional.of(clazz.cast(blockDurationMinutes()));
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "LaunchGroup":
            return Optional.of(clazz.cast(launchGroup()));
        case "LaunchSpecification":
            return Optional.of(clazz.cast(launchSpecification()));
        case "SpotPrice":
            return Optional.of(clazz.cast(spotPrice()));
        case "Type":
            return Optional.of(clazz.cast(typeAsString()));
        case "ValidFrom":
            return Optional.of(clazz.cast(validFrom()));
        case "ValidUntil":
            return Optional.of(clazz.cast(validUntil()));
        case "InstanceInterruptionBehavior":
            return Optional.of(clazz.cast(instanceInterruptionBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, RequestSpotInstancesRequest> {
        /**
         * <p>
         * The user-specified name for a logical grouping of bids.
         * </p>
         * <p>
         * When you specify an Availability Zone group in a Spot Instance request, all Spot instances in the request are
         * launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice
         * of Availability Zone is not. The group applies only to bids for Spot Instances of the same instance type. Any
         * additional Spot instance requests that are specified with the same Availability Zone group name are launched
         * in that same Availability Zone, as long as at least one instance from the group is still active.
         * </p>
         * <p>
         * If there is no active instance running in the Availability Zone group that you specify for a new Spot
         * instance request (all instances are terminated, the bid is expired, or the bid falls below current market),
         * then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently,
         * the subsequent set of Spot instances could be placed in a different zone from the original request, even if
         * you specified the same Availability Zone group.
         * </p>
         * <p>
         * Default: Instances are launched in any available Availability Zone.
         * </p>
         * 
         * @param availabilityZoneGroup
         *        The user-specified name for a logical grouping of bids.</p>
         *        <p>
         *        When you specify an Availability Zone group in a Spot Instance request, all Spot instances in the
         *        request are launched in the same Availability Zone. Instance proximity is maintained with this
         *        parameter, but the choice of Availability Zone is not. The group applies only to bids for Spot
         *        Instances of the same instance type. Any additional Spot instance requests that are specified with the
         *        same Availability Zone group name are launched in that same Availability Zone, as long as at least one
         *        instance from the group is still active.
         *        </p>
         *        <p>
         *        If there is no active instance running in the Availability Zone group that you specify for a new Spot
         *        instance request (all instances are terminated, the bid is expired, or the bid falls below current
         *        market), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be
         *        met. Consequently, the subsequent set of Spot instances could be placed in a different zone from the
         *        original request, even if you specified the same Availability Zone group.
         *        </p>
         *        <p>
         *        Default: Instances are launched in any available Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneGroup(String availabilityZoneGroup);

        /**
         * <p>
         * The required duration for the Spot instances (also known as Spot blocks), in minutes. This value must be a
         * multiple of 60 (60, 120, 180, 240, 300, or 360).
         * </p>
         * <p>
         * The duration period starts as soon as your Spot instance receives its instance ID. At the end of the duration
         * period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance termination notice,
         * which gives the instance a two-minute warning before it terminates.
         * </p>
         * <p>
         * Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
         * </p>
         * 
         * @param blockDurationMinutes
         *        The required duration for the Spot instances (also known as Spot blocks), in minutes. This value must
         *        be a multiple of 60 (60, 120, 180, 240, 300, or 360).</p>
         *        <p>
         *        The duration period starts as soon as your Spot instance receives its instance ID. At the end of the
         *        duration period, Amazon EC2 marks the Spot instance for termination and provides a Spot instance
         *        termination notice, which gives the instance a two-minute warning before it terminates.
         *        </p>
         *        <p>
         *        Note that you can't specify an Availability Zone group or a launch group if you specify a duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDurationMinutes(Integer blockDurationMinutes);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         * Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html">How to Ensure
         *        Idempotency</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The maximum number of Spot instances to launch.
         * </p>
         * <p>
         * Default: 1
         * </p>
         * 
         * @param instanceCount
         *        The maximum number of Spot instances to launch.</p>
         *        <p>
         *        Default: 1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance launch group. Launch groups are Spot instances that launch together and terminate together.
         * </p>
         * <p>
         * Default: Instances are launched and terminated individually
         * </p>
         * 
         * @param launchGroup
         *        The instance launch group. Launch groups are Spot instances that launch together and terminate
         *        together.</p>
         *        <p>
         *        Default: Instances are launched and terminated individually
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchGroup(String launchGroup);

        /**
         * <p>
         * The launch specification.
         * </p>
         * 
         * @param launchSpecification
         *        The launch specification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchSpecification(LaunchSpecification launchSpecification);

        /**
         * <p>
         * The launch specification.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchSpecification.Builder} avoiding the need
         * to create one manually via {@link LaunchSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #launchSpecification(LaunchSpecification)}.
         * 
         * @param launchSpecification
         *        a consumer that will call methods on {@link LaunchSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchSpecification(LaunchSpecification)
         */
        default Builder launchSpecification(Consumer<LaunchSpecification.Builder> launchSpecification) {
            return launchSpecification(LaunchSpecification.builder().apply(launchSpecification).build());
        }

        /**
         * <p>
         * The maximum hourly price (bid) for any Spot instance launched to fulfill the request.
         * </p>
         * 
         * @param spotPrice
         *        The maximum hourly price (bid) for any Spot instance launched to fulfill the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotPrice(String spotPrice);

        /**
         * <p>
         * The Spot instance request type.
         * </p>
         * <p>
         * Default: <code>one-time</code>
         * </p>
         * 
         * @param type
         *        The Spot instance request type.</p>
         *        <p>
         *        Default: <code>one-time</code>
         * @see SpotInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceType
         */
        Builder type(String type);

        /**
         * <p>
         * The Spot instance request type.
         * </p>
         * <p>
         * Default: <code>one-time</code>
         * </p>
         * 
         * @param type
         *        The Spot instance request type.</p>
         *        <p>
         *        Default: <code>one-time</code>
         * @see SpotInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceType
         */
        Builder type(SpotInstanceType type);

        /**
         * <p>
         * The start date of the request. If this is a one-time request, the request becomes active at this date and
         * time and remains active until all instances launch, the request expires, or the request is canceled. If the
         * request is persistent, the request becomes active at this date and time and remains active until it expires
         * or is canceled.
         * </p>
         * <p>
         * Default: The request is effective indefinitely.
         * </p>
         * 
         * @param validFrom
         *        The start date of the request. If this is a one-time request, the request becomes active at this date
         *        and time and remains active until all instances launch, the request expires, or the request is
         *        canceled. If the request is persistent, the request becomes active at this date and time and remains
         *        active until it expires or is canceled.</p>
         *        <p>
         *        Default: The request is effective indefinitely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validFrom(Instant validFrom);

        /**
         * <p>
         * The end date of the request. If this is a one-time request, the request remains active until all instances
         * launch, the request is canceled, or this date is reached. If the request is persistent, it remains active
         * until it is canceled or this date and time is reached.
         * </p>
         * <p>
         * Default: The request is effective indefinitely.
         * </p>
         * 
         * @param validUntil
         *        The end date of the request. If this is a one-time request, the request remains active until all
         *        instances launch, the request is canceled, or this date is reached. If the request is persistent, it
         *        remains active until it is canceled or this date and time is reached.</p>
         *        <p>
         *        Default: The request is effective indefinitely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);

        /**
         * <p>
         * Indicates whether a Spot instance stops or terminates when it is interrupted.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        Indicates whether a Spot instance stops or terminates when it is interrupted.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * Indicates whether a Spot instance stops or terminates when it is interrupted.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        Indicates whether a Spot instance stops or terminates when it is interrupted.
         * @see InstanceInterruptionBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehavior
         */
        Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String availabilityZoneGroup;

        private Integer blockDurationMinutes;

        private String clientToken;

        private Integer instanceCount;

        private String launchGroup;

        private LaunchSpecification launchSpecification;

        private String spotPrice;

        private String type;

        private Instant validFrom;

        private Instant validUntil;

        private String instanceInterruptionBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSpotInstancesRequest model) {
            super(model);
            availabilityZoneGroup(model.availabilityZoneGroup);
            blockDurationMinutes(model.blockDurationMinutes);
            clientToken(model.clientToken);
            instanceCount(model.instanceCount);
            launchGroup(model.launchGroup);
            launchSpecification(model.launchSpecification);
            spotPrice(model.spotPrice);
            type(model.type);
            validFrom(model.validFrom);
            validUntil(model.validUntil);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
        }

        public final String getAvailabilityZoneGroup() {
            return availabilityZoneGroup;
        }

        @Override
        public final Builder availabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
            return this;
        }

        public final void setAvailabilityZoneGroup(String availabilityZoneGroup) {
            this.availabilityZoneGroup = availabilityZoneGroup;
        }

        public final Integer getBlockDurationMinutes() {
            return blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getLaunchGroup() {
            return launchGroup;
        }

        @Override
        public final Builder launchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
            return this;
        }

        public final void setLaunchGroup(String launchGroup) {
            this.launchGroup = launchGroup;
        }

        public final LaunchSpecification.Builder getLaunchSpecification() {
            return launchSpecification != null ? launchSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchSpecification(LaunchSpecification launchSpecification) {
            this.launchSpecification = launchSpecification;
            return this;
        }

        public final void setLaunchSpecification(LaunchSpecification.BuilderImpl launchSpecification) {
            this.launchSpecification = launchSpecification != null ? launchSpecification.build() : null;
        }

        public final String getSpotPrice() {
            return spotPrice;
        }

        @Override
        public final Builder spotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        public final void setSpotPrice(String spotPrice) {
            this.spotPrice = spotPrice;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SpotInstanceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getValidFrom() {
            return validFrom;
        }

        @Override
        public final Builder validFrom(Instant validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        public final void setValidFrom(Instant validFrom) {
            this.validFrom = validFrom;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehavior instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior.toString());
            return this;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RequestSpotInstancesRequest build() {
            return new RequestSpotInstancesRequest(this);
        }
    }
}
