/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the limit price of a Reserved Instance offering.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstanceLimitPrice implements
        ToCopyableBuilder<ReservedInstanceLimitPrice.Builder, ReservedInstanceLimitPrice> {
    private final Double amount;

    private final String currencyCode;

    private ReservedInstanceLimitPrice(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
    }

    /**
     * <p>
     * Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount *
     * price).
     * </p>
     * 
     * @return Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order
     *         (instanceCount * price).
     */
    public Double amount() {
        return amount;
    }

    /**
     * <p>
     * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency
     * is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
     *         currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public CurrencyCodeValues currencyCode() {
        return CurrencyCodeValues.fromValue(currencyCode);
    }

    /**
     * <p>
     * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported currency
     * is <code>USD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link CurrencyCodeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
     *         currency is <code>USD</code>.
     * @see CurrencyCodeValues
     */
    public String currencyCodeAsString() {
        return currencyCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstanceLimitPrice)) {
            return false;
        }
        ReservedInstanceLimitPrice other = (ReservedInstanceLimitPrice) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("ReservedInstanceLimitPrice").add("Amount", amount()).add("CurrencyCode", currencyCodeAsString())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.of(clazz.cast(amount()));
        case "CurrencyCode":
            return Optional.of(clazz.cast(currencyCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstanceLimitPrice> {
        /**
         * <p>
         * Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order (instanceCount
         * * price).
         * </p>
         * 
         * @param amount
         *        Used for Reserved Instance Marketplace offerings. Specifies the limit price on the total order
         *        (instanceCount * price).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Double amount);

        /**
         * <p>
         * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
         * currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>limitPrice</code> amount is specified. At this time, the only
         *        supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The currency in which the <code>limitPrice</code> amount is specified. At this time, the only supported
         * currency is <code>USD</code>.
         * </p>
         * 
         * @param currencyCode
         *        The currency in which the <code>limitPrice</code> amount is specified. At this time, the only
         *        supported currency is <code>USD</code>.
         * @see CurrencyCodeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrencyCodeValues
         */
        Builder currencyCode(CurrencyCodeValues currencyCode);
    }

    static final class BuilderImpl implements Builder {
        private Double amount;

        private String currencyCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstanceLimitPrice model) {
            amount(model.amount);
            currencyCode(model.currencyCode);
        }

        public final Double getAmount() {
            return amount;
        }

        @Override
        public final Builder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(Double amount) {
            this.amount = amount;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(CurrencyCodeValues currencyCode) {
            this.currencyCode(currencyCode.toString());
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public ReservedInstanceLimitPrice build() {
            return new ReservedInstanceLimitPrice(this);
        }
    }
}
