/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Reserved Instance listing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReservedInstancesListing implements ToCopyableBuilder<ReservedInstancesListing.Builder, ReservedInstancesListing> {
    private final String clientToken;

    private final Instant createDate;

    private final List<InstanceCount> instanceCounts;

    private final List<PriceSchedule> priceSchedules;

    private final String reservedInstancesId;

    private final String reservedInstancesListingId;

    private final String status;

    private final String statusMessage;

    private final List<Tag> tags;

    private final Instant updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    /**
     * <p>
     * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     * information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
     *         information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The time the listing was created.
     * </p>
     * 
     * @return The time the listing was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The number of instances in this state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The number of instances in this state.
     */
    public List<InstanceCount> instanceCounts() {
        return instanceCounts;
    }

    /**
     * <p>
     * The price of the Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The price of the Reserved Instance listing.
     */
    public List<PriceSchedule> priceSchedules() {
        return priceSchedules;
    }

    /**
     * <p>
     * The ID of the Reserved Instance.
     * </p>
     * 
     * @return The ID of the Reserved Instance.
     */
    public String reservedInstancesId() {
        return reservedInstancesId;
    }

    /**
     * <p>
     * The ID of the Reserved Instance listing.
     * </p>
     * 
     * @return The ID of the Reserved Instance listing.
     */
    public String reservedInstancesListingId() {
        return reservedInstancesListingId;
    }

    /**
     * <p>
     * The status of the Reserved Instance listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Reserved Instance listing.
     * @see ListingStatus
     */
    public ListingStatus status() {
        return ListingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Reserved Instance listing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ListingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Reserved Instance listing.
     * @see ListingStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the Reserved Instance listing. The response can be blank.
     * </p>
     * 
     * @return The reason for the current status of the Reserved Instance listing. The response can be blank.
     */
    public String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * Any tags assigned to the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the resource.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The last modified timestamp of the listing.
     * </p>
     * 
     * @return The last modified timestamp of the listing.
     */
    public Instant updateDate() {
        return updateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedInstancesListingId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(updateDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(instanceCounts(), other.instanceCounts())
                && Objects.equals(priceSchedules(), other.priceSchedules())
                && Objects.equals(reservedInstancesId(), other.reservedInstancesId())
                && Objects.equals(reservedInstancesListingId(), other.reservedInstancesListingId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(tags(), other.tags())
                && Objects.equals(updateDate(), other.updateDate());
    }

    @Override
    public String toString() {
        return ToString.builder("ReservedInstancesListing").add("ClientToken", clientToken()).add("CreateDate", createDate())
                .add("InstanceCounts", instanceCounts()).add("PriceSchedules", priceSchedules())
                .add("ReservedInstancesId", reservedInstancesId())
                .add("ReservedInstancesListingId", reservedInstancesListingId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("Tags", tags()).add("UpdateDate", updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.of(clazz.cast(clientToken()));
        case "CreateDate":
            return Optional.of(clazz.cast(createDate()));
        case "InstanceCounts":
            return Optional.of(clazz.cast(instanceCounts()));
        case "PriceSchedules":
            return Optional.of(clazz.cast(priceSchedules()));
        case "ReservedInstancesId":
            return Optional.of(clazz.cast(reservedInstancesId()));
        case "ReservedInstancesListingId":
            return Optional.of(clazz.cast(reservedInstancesListingId()));
        case "Status":
            return Optional.of(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.of(clazz.cast(statusMessage()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "UpdateDate":
            return Optional.of(clazz.cast(updateDate()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ReservedInstancesListing> {
        /**
         * <p>
         * A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         * information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive key supplied by the client to ensure that the request is idempotent. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The time the listing was created.
         * </p>
         * 
         * @param createDate
         *        The time the listing was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(Collection<InstanceCount> instanceCounts);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * 
         * @param instanceCounts
         *        The number of instances in this state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCounts(InstanceCount... instanceCounts);

        /**
         * <p>
         * The number of instances in this state.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceCount>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceCount>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceCount>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceCounts(List<InstanceCount>)}.
         * 
         * @param instanceCounts
         *        a consumer that will call methods on {@link List<InstanceCount>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCounts(List<InstanceCount>)
         */
        Builder instanceCounts(Consumer<InstanceCount.Builder>... instanceCounts);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(Collection<PriceSchedule> priceSchedules);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * 
         * @param priceSchedules
         *        The price of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priceSchedules(PriceSchedule... priceSchedules);

        /**
         * <p>
         * The price of the Reserved Instance listing.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PriceSchedule>.Builder} avoiding the need
         * to create one manually via {@link List<PriceSchedule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PriceSchedule>.Builder#build()} is called immediately and
         * its result is passed to {@link #priceSchedules(List<PriceSchedule>)}.
         * 
         * @param priceSchedules
         *        a consumer that will call methods on {@link List<PriceSchedule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #priceSchedules(List<PriceSchedule>)
         */
        Builder priceSchedules(Consumer<PriceSchedule.Builder>... priceSchedules);

        /**
         * <p>
         * The ID of the Reserved Instance.
         * </p>
         * 
         * @param reservedInstancesId
         *        The ID of the Reserved Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesId(String reservedInstancesId);

        /**
         * <p>
         * The ID of the Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListingId
         *        The ID of the Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListingId(String reservedInstancesListingId);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Reserved Instance listing.
         * </p>
         * 
         * @param status
         *        The status of the Reserved Instance listing.
         * @see ListingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListingStatus
         */
        Builder status(ListingStatus status);

        /**
         * <p>
         * The reason for the current status of the Reserved Instance listing. The response can be blank.
         * </p>
         * 
         * @param statusMessage
         *        The reason for the current status of the Reserved Instance listing. The response can be blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The last modified timestamp of the listing.
         * </p>
         * 
         * @param updateDate
         *        The last modified timestamp of the listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDate(Instant updateDate);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private Instant createDate;

        private List<InstanceCount> instanceCounts;

        private List<PriceSchedule> priceSchedules;

        private String reservedInstancesId;

        private String reservedInstancesListingId;

        private String status;

        private String statusMessage;

        private List<Tag> tags;

        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            clientToken(model.clientToken);
            createDate(model.createDate);
            instanceCounts(model.instanceCounts);
            priceSchedules(model.priceSchedules);
            reservedInstancesId(model.reservedInstancesId);
            reservedInstancesListingId(model.reservedInstancesListingId);
            status(model.status);
            statusMessage(model.statusMessage);
            tags(model.tags);
            updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<InstanceCount.Builder> getInstanceCounts() {
            return instanceCounts != null ? instanceCounts.stream().map(InstanceCount::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount... instanceCounts) {
            instanceCounts(Arrays.asList(instanceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(Consumer<InstanceCount.Builder>... instanceCounts) {
            instanceCounts(Stream.of(instanceCounts).map(c -> InstanceCount.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount.BuilderImpl> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copyFromBuilder(instanceCounts);
        }

        public final Collection<PriceSchedule.Builder> getPriceSchedules() {
            return priceSchedules != null ? priceSchedules.stream().map(PriceSchedule::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule... priceSchedules) {
            priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceSchedule.Builder>... priceSchedules) {
            priceSchedules(Stream.of(priceSchedules).map(c -> PriceSchedule.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getUpdateDate() {
            return updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        @Override
        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }
    }
}
