/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for ResetSnapshotAttribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ResetSnapshotAttributeRequest extends EC2Request implements
        ToCopyableBuilder<ResetSnapshotAttributeRequest.Builder, ResetSnapshotAttributeRequest> {
    private final String attribute;

    private final String snapshotId;

    private ResetSnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.snapshotId = builder.snapshotId;
    }

    /**
     * <p>
     * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * @see SnapshotAttributeName
     */
    public SnapshotAttributeName attribute() {
        return SnapshotAttributeName.fromValue(attribute);
    }

    /**
     * <p>
     * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link SnapshotAttributeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #attributeAsString}.
     * </p>
     * 
     * @return The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
     * @see SnapshotAttributeName
     */
    public String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The ID of the snapshot.
     * </p>
     * 
     * @return The ID of the snapshot.
     */
    public String snapshotId() {
        return snapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetSnapshotAttributeRequest)) {
            return false;
        }
        ResetSnapshotAttributeRequest other = (ResetSnapshotAttributeRequest) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(snapshotId(), other.snapshotId());
    }

    @Override
    public String toString() {
        return ToString.builder("ResetSnapshotAttributeRequest").add("Attribute", attributeAsString())
                .add("SnapshotId", snapshotId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.of(clazz.cast(attributeAsString()));
        case "SnapshotId":
            return Optional.of(clazz.cast(snapshotId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Request.Builder, CopyableBuilder<Builder, ResetSnapshotAttributeRequest> {
        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * </p>
         * 
         * @param attribute
         *        The attribute to reset. Currently, only the attribute for permission to create volumes can be reset.
         * @see SnapshotAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotAttributeName
         */
        Builder attribute(SnapshotAttributeName attribute);

        /**
         * <p>
         * The ID of the snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The ID of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);

        @Override
        Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EC2Request.BuilderImpl implements Builder {
        private String attribute;

        private String snapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetSnapshotAttributeRequest model) {
            super(model);
            attribute(model.attribute);
            snapshotId(model.snapshotId);
        }

        public final String getAttribute() {
            return attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ResetSnapshotAttributeRequest build() {
            return new ResetSnapshotAttributeRequest(this);
        }
    }
}
