/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route in a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Route implements ToCopyableBuilder<Route.Builder, Route> {
    private final String destinationCidrBlock;

    private final String destinationIpv6CidrBlock;

    private final String destinationPrefixListId;

    private final String egressOnlyInternetGatewayId;

    private final String gatewayId;

    private final String instanceId;

    private final String instanceOwnerId;

    private final String natGatewayId;

    private final String networkInterfaceId;

    private final String origin;

    private final String state;

    private final String vpcPeeringConnectionId;

    private Route(BuilderImpl builder) {
        this.destinationCidrBlock = builder.destinationCidrBlock;
        this.destinationIpv6CidrBlock = builder.destinationIpv6CidrBlock;
        this.destinationPrefixListId = builder.destinationPrefixListId;
        this.egressOnlyInternetGatewayId = builder.egressOnlyInternetGatewayId;
        this.gatewayId = builder.gatewayId;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.natGatewayId = builder.natGatewayId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.origin = builder.origin;
        this.state = builder.state;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    /**
     * <p>
     * The IPv4 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv4 CIDR block used for the destination match.
     */
    public String destinationCidrBlock() {
        return destinationCidrBlock;
    }

    /**
     * <p>
     * The IPv6 CIDR block used for the destination match.
     * </p>
     * 
     * @return The IPv6 CIDR block used for the destination match.
     */
    public String destinationIpv6CidrBlock() {
        return destinationIpv6CidrBlock;
    }

    /**
     * <p>
     * The prefix of the AWS service.
     * </p>
     * 
     * @return The prefix of the AWS service.
     */
    public String destinationPrefixListId() {
        return destinationPrefixListId;
    }

    /**
     * <p>
     * The ID of the egress-only Internet gateway.
     * </p>
     * 
     * @return The ID of the egress-only Internet gateway.
     */
    public String egressOnlyInternetGatewayId() {
        return egressOnlyInternetGatewayId;
    }

    /**
     * <p>
     * The ID of a gateway attached to your VPC.
     * </p>
     * 
     * @return The ID of a gateway attached to your VPC.
     */
    public String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The ID of a NAT instance in your VPC.
     * </p>
     * 
     * @return The ID of a NAT instance in your VPC.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the instance.
     * </p>
     * 
     * @return The AWS account ID of the owner of the instance.
     */
    public String instanceOwnerId() {
        return instanceOwnerId;
    }

    /**
     * <p>
     * The ID of a NAT gateway.
     * </p>
     * 
     * @return The ID of a NAT gateway.
     */
    public String natGatewayId() {
        return natGatewayId;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link RouteOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Describes how the route was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     * @see RouteOrigin
     */
    public RouteOrigin origin() {
        return RouteOrigin.fromValue(origin);
    }

    /**
     * <p>
     * Describes how the route was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CreateRoute</code> - The route was manually added to the route table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #origin} will
     * return {@link RouteOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #originAsString}.
     * </p>
     * 
     * @return Describes how the route was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CreateRoute</code> - The route was manually added to the route table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
     *         </p>
     *         </li>
     * @see RouteOrigin
     */
    public String originAsString() {
        return origin;
    }

    /**
     * <p>
     * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available (for
     * example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
     *         available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
     *         has been terminated).
     * @see RouteState
     */
    public RouteState state() {
        return RouteState.fromValue(state);
    }

    /**
     * <p>
     * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available (for
     * example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link RouteState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
     *         available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
     *         has been terminated).
     * @see RouteState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC peering connection.
     */
    public String vpcPeeringConnectionId() {
        return vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPrefixListId());
        hashCode = 31 * hashCode + Objects.hashCode(egressOnlyInternetGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(natGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(originAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcPeeringConnectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route) obj;
        return Objects.equals(destinationCidrBlock(), other.destinationCidrBlock())
                && Objects.equals(destinationIpv6CidrBlock(), other.destinationIpv6CidrBlock())
                && Objects.equals(destinationPrefixListId(), other.destinationPrefixListId())
                && Objects.equals(egressOnlyInternetGatewayId(), other.egressOnlyInternetGatewayId())
                && Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceOwnerId(), other.instanceOwnerId())
                && Objects.equals(natGatewayId(), other.natGatewayId())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(originAsString(), other.originAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    @Override
    public String toString() {
        return ToString.builder("Route").add("DestinationCidrBlock", destinationCidrBlock())
                .add("DestinationIpv6CidrBlock", destinationIpv6CidrBlock())
                .add("DestinationPrefixListId", destinationPrefixListId())
                .add("EgressOnlyInternetGatewayId", egressOnlyInternetGatewayId()).add("GatewayId", gatewayId())
                .add("InstanceId", instanceId()).add("InstanceOwnerId", instanceOwnerId()).add("NatGatewayId", natGatewayId())
                .add("NetworkInterfaceId", networkInterfaceId()).add("Origin", originAsString()).add("State", stateAsString())
                .add("VpcPeeringConnectionId", vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationCidrBlock":
            return Optional.of(clazz.cast(destinationCidrBlock()));
        case "DestinationIpv6CidrBlock":
            return Optional.of(clazz.cast(destinationIpv6CidrBlock()));
        case "DestinationPrefixListId":
            return Optional.of(clazz.cast(destinationPrefixListId()));
        case "EgressOnlyInternetGatewayId":
            return Optional.of(clazz.cast(egressOnlyInternetGatewayId()));
        case "GatewayId":
            return Optional.of(clazz.cast(gatewayId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "InstanceOwnerId":
            return Optional.of(clazz.cast(instanceOwnerId()));
        case "NatGatewayId":
            return Optional.of(clazz.cast(natGatewayId()));
        case "NetworkInterfaceId":
            return Optional.of(clazz.cast(networkInterfaceId()));
        case "Origin":
            return Optional.of(clazz.cast(originAsString()));
        case "State":
            return Optional.of(clazz.cast(stateAsString()));
        case "VpcPeeringConnectionId":
            return Optional.of(clazz.cast(vpcPeeringConnectionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Route> {
        /**
         * <p>
         * The IPv4 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationCidrBlock
         *        The IPv4 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationCidrBlock(String destinationCidrBlock);

        /**
         * <p>
         * The IPv6 CIDR block used for the destination match.
         * </p>
         * 
         * @param destinationIpv6CidrBlock
         *        The IPv6 CIDR block used for the destination match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock);

        /**
         * <p>
         * The prefix of the AWS service.
         * </p>
         * 
         * @param destinationPrefixListId
         *        The prefix of the AWS service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPrefixListId(String destinationPrefixListId);

        /**
         * <p>
         * The ID of the egress-only Internet gateway.
         * </p>
         * 
         * @param egressOnlyInternetGatewayId
         *        The ID of the egress-only Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId);

        /**
         * <p>
         * The ID of a gateway attached to your VPC.
         * </p>
         * 
         * @param gatewayId
         *        The ID of a gateway attached to your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The ID of a NAT instance in your VPC.
         * </p>
         * 
         * @param instanceId
         *        The ID of a NAT instance in your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The AWS account ID of the owner of the instance.
         * </p>
         * 
         * @param instanceOwnerId
         *        The AWS account ID of the owner of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceOwnerId(String instanceOwnerId);

        /**
         * <p>
         * The ID of a NAT gateway.
         * </p>
         * 
         * @param natGatewayId
         *        The ID of a NAT gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder natGatewayId(String natGatewayId);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(String origin);

        /**
         * <p>
         * Describes how the route was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CreateRoute</code> - The route was manually added to the route table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         * </p>
         * </li>
         * </ul>
         * 
         * @param origin
         *        Describes how the route was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CreateRouteTable</code> - The route was automatically created when the route table was created.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CreateRoute</code> - The route was manually added to the route table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EnableVgwRoutePropagation</code> - The route was propagated by route propagation.
         *        </p>
         *        </li>
         * @see RouteOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteOrigin
         */
        Builder origin(RouteOrigin origin);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the route. The <code>blackhole</code> state indicates that the route's target isn't available
         * (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been
         * terminated).
         * </p>
         * 
         * @param state
         *        The state of the route. The <code>blackhole</code> state indicates that the route's target isn't
         *        available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance
         *        has been terminated).
         * @see RouteState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RouteState
         */
        Builder state(RouteState state);

        /**
         * <p>
         * The ID of the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnectionId
         *        The ID of the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionId(String vpcPeeringConnectionId);
    }

    static final class BuilderImpl implements Builder {
        private String destinationCidrBlock;

        private String destinationIpv6CidrBlock;

        private String destinationPrefixListId;

        private String egressOnlyInternetGatewayId;

        private String gatewayId;

        private String instanceId;

        private String instanceOwnerId;

        private String natGatewayId;

        private String networkInterfaceId;

        private String origin;

        private String state;

        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            destinationCidrBlock(model.destinationCidrBlock);
            destinationIpv6CidrBlock(model.destinationIpv6CidrBlock);
            destinationPrefixListId(model.destinationPrefixListId);
            egressOnlyInternetGatewayId(model.egressOnlyInternetGatewayId);
            gatewayId(model.gatewayId);
            instanceId(model.instanceId);
            instanceOwnerId(model.instanceOwnerId);
            natGatewayId(model.natGatewayId);
            networkInterfaceId(model.networkInterfaceId);
            origin(model.origin);
            state(model.state);
            vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final String getDestinationCidrBlock() {
            return destinationCidrBlock;
        }

        @Override
        public final Builder destinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
            return this;
        }

        public final void setDestinationCidrBlock(String destinationCidrBlock) {
            this.destinationCidrBlock = destinationCidrBlock;
        }

        public final String getDestinationIpv6CidrBlock() {
            return destinationIpv6CidrBlock;
        }

        @Override
        public final Builder destinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
            return this;
        }

        public final void setDestinationIpv6CidrBlock(String destinationIpv6CidrBlock) {
            this.destinationIpv6CidrBlock = destinationIpv6CidrBlock;
        }

        public final String getDestinationPrefixListId() {
            return destinationPrefixListId;
        }

        @Override
        public final Builder destinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
            return this;
        }

        public final void setDestinationPrefixListId(String destinationPrefixListId) {
            this.destinationPrefixListId = destinationPrefixListId;
        }

        public final String getEgressOnlyInternetGatewayId() {
            return egressOnlyInternetGatewayId;
        }

        @Override
        public final Builder egressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
            return this;
        }

        public final void setEgressOnlyInternetGatewayId(String egressOnlyInternetGatewayId) {
            this.egressOnlyInternetGatewayId = egressOnlyInternetGatewayId;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getNatGatewayId() {
            return natGatewayId;
        }

        @Override
        public final Builder natGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
            return this;
        }

        public final void setNatGatewayId(String natGatewayId) {
            this.natGatewayId = natGatewayId;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getOrigin() {
            return origin;
        }

        @Override
        public final Builder origin(String origin) {
            this.origin = origin;
            return this;
        }

        @Override
        public final Builder origin(RouteOrigin origin) {
            this.origin(origin.toString());
            return this;
        }

        public final void setOrigin(String origin) {
            this.origin = origin;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouteState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcPeeringConnectionId() {
            return vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Route build() {
            return new Route(this);
        }
    }
}
