/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a route table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RouteTable implements ToCopyableBuilder<RouteTable.Builder, RouteTable> {
    private final List<RouteTableAssociation> associations;

    private final List<PropagatingVgw> propagatingVgws;

    private final String routeTableId;

    private final List<Route> routes;

    private final List<Tag> tags;

    private final String vpcId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The associations between the route table and one or more subnets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The associations between the route table and one or more subnets.
     */
    public List<RouteTableAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * Any virtual private gateway (VGW) propagating routes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any virtual private gateway (VGW) propagating routes.
     */
    public List<PropagatingVgw> propagatingVgws() {
        return propagatingVgws;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The routes in the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The routes in the route table.
     */
    public List<Route> routes() {
        return routes;
    }

    /**
     * <p>
     * Any tags assigned to the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the route table.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associations());
        hashCode = 31 * hashCode + Objects.hashCode(propagatingVgws());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(routes());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable) obj;
        return Objects.equals(associations(), other.associations()) && Objects.equals(propagatingVgws(), other.propagatingVgws())
                && Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(routes(), other.routes())
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    @Override
    public String toString() {
        return ToString.builder("RouteTable").add("Associations", associations()).add("PropagatingVgws", propagatingVgws())
                .add("RouteTableId", routeTableId()).add("Routes", routes()).add("Tags", tags()).add("VpcId", vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Associations":
            return Optional.of(clazz.cast(associations()));
        case "PropagatingVgws":
            return Optional.of(clazz.cast(propagatingVgws()));
        case "RouteTableId":
            return Optional.of(clazz.cast(routeTableId()));
        case "Routes":
            return Optional.of(clazz.cast(routes()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, RouteTable> {
        /**
         * <p>
         * The associations between the route table and one or more subnets.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<RouteTableAssociation> associations);

        /**
         * <p>
         * The associations between the route table and one or more subnets.
         * </p>
         * 
         * @param associations
         *        The associations between the route table and one or more subnets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(RouteTableAssociation... associations);

        /**
         * <p>
         * The associations between the route table and one or more subnets.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteTableAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<RouteTableAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteTableAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<RouteTableAssociation>)}.
         * 
         * @param associations
         *        a consumer that will call methods on {@link List<RouteTableAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(List<RouteTableAssociation>)
         */
        Builder associations(Consumer<RouteTableAssociation.Builder>... associations);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * 
         * @param propagatingVgws
         *        Any virtual private gateway (VGW) propagating routes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgws(PropagatingVgw... propagatingVgws);

        /**
         * <p>
         * Any virtual private gateway (VGW) propagating routes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PropagatingVgw>.Builder} avoiding the need
         * to create one manually via {@link List<PropagatingVgw>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PropagatingVgw>.Builder#build()} is called immediately and
         * its result is passed to {@link #propagatingVgws(List<PropagatingVgw>)}.
         * 
         * @param propagatingVgws
         *        a consumer that will call methods on {@link List<PropagatingVgw>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propagatingVgws(List<PropagatingVgw>)
         */
        Builder propagatingVgws(Consumer<PropagatingVgw.Builder>... propagatingVgws);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routes
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Route>.Builder} avoiding the need to create
         * one manually via {@link List<Route>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Route>.Builder#build()} is called immediately and its result
         * is passed to {@link #routes(List<Route>)}.
         * 
         * @param routes
         *        a consumer that will call methods on {@link List<Route>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(List<Route>)
         */
        Builder routes(Consumer<Route.Builder>... routes);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the route table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<RouteTableAssociation> associations;

        private List<PropagatingVgw> propagatingVgws;

        private String routeTableId;

        private List<Route> routes;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            associations(model.associations);
            propagatingVgws(model.propagatingVgws);
            routeTableId(model.routeTableId);
            routes(model.routes);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final Collection<RouteTableAssociation.Builder> getAssociations() {
            return associations != null ? associations.stream().map(RouteTableAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<RouteTableAssociation.Builder>... associations) {
            associations(Stream.of(associations).map(c -> RouteTableAssociation.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation.BuilderImpl> associations) {
            this.associations = RouteTableAssociationListCopier.copyFromBuilder(associations);
        }

        public final Collection<PropagatingVgw.Builder> getPropagatingVgws() {
            return propagatingVgws != null ? propagatingVgws.stream().map(PropagatingVgw::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw... propagatingVgws) {
            propagatingVgws(Arrays.asList(propagatingVgws));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(Consumer<PropagatingVgw.Builder>... propagatingVgws) {
            propagatingVgws(Stream.of(propagatingVgws).map(c -> PropagatingVgw.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw.BuilderImpl> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copyFromBuilder(propagatingVgws);
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route.Builder> getRoutes() {
            return routes != null ? routes.stream().map(Route::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder>... routes) {
            routes(Stream.of(routes).map(c -> Route.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public RouteTable build() {
            return new RouteTable(this);
        }
    }
}
