/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Scheduled Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScheduledInstance implements ToCopyableBuilder<ScheduledInstance.Builder, ScheduledInstance> {
    private final String availabilityZone;

    private final Instant createDate;

    private final String hourlyPrice;

    private final Integer instanceCount;

    private final String instanceType;

    private final String networkPlatform;

    private final Instant nextSlotStartTime;

    private final String platform;

    private final Instant previousSlotEndTime;

    private final ScheduledInstanceRecurrence recurrence;

    private final String scheduledInstanceId;

    private final Integer slotDurationInHours;

    private final Instant termEndDate;

    private final Instant termStartDate;

    private final Integer totalScheduledInstanceHours;

    private ScheduledInstance(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.createDate = builder.createDate;
        this.hourlyPrice = builder.hourlyPrice;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.networkPlatform = builder.networkPlatform;
        this.nextSlotStartTime = builder.nextSlotStartTime;
        this.platform = builder.platform;
        this.previousSlotEndTime = builder.previousSlotEndTime;
        this.recurrence = builder.recurrence;
        this.scheduledInstanceId = builder.scheduledInstanceId;
        this.slotDurationInHours = builder.slotDurationInHours;
        this.termEndDate = builder.termEndDate;
        this.termStartDate = builder.termStartDate;
        this.totalScheduledInstanceHours = builder.totalScheduledInstanceHours;
    }

    /**
     * <p>
     * The Availability Zone.
     * </p>
     * 
     * @return The Availability Zone.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The date when the Scheduled Instance was purchased.
     * </p>
     * 
     * @return The date when the Scheduled Instance was purchased.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The hourly price for a single instance.
     * </p>
     * 
     * @return The hourly price for a single instance.
     */
    public String hourlyPrice() {
        return hourlyPrice;
    }

    /**
     * <p>
     * The number of instances.
     * </p>
     * 
     * @return The number of instances.
     */
    public Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     * </p>
     * 
     * @return The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
     */
    public String networkPlatform() {
        return networkPlatform;
    }

    /**
     * <p>
     * The time for the next schedule to start.
     * </p>
     * 
     * @return The time for the next schedule to start.
     */
    public Instant nextSlotStartTime() {
        return nextSlotStartTime;
    }

    /**
     * <p>
     * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     * </p>
     * 
     * @return The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The time that the previous schedule ended or will end.
     * </p>
     * 
     * @return The time that the previous schedule ended or will end.
     */
    public Instant previousSlotEndTime() {
        return previousSlotEndTime;
    }

    /**
     * <p>
     * The schedule recurrence.
     * </p>
     * 
     * @return The schedule recurrence.
     */
    public ScheduledInstanceRecurrence recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The Scheduled Instance ID.
     * </p>
     * 
     * @return The Scheduled Instance ID.
     */
    public String scheduledInstanceId() {
        return scheduledInstanceId;
    }

    /**
     * <p>
     * The number of hours in the schedule.
     * </p>
     * 
     * @return The number of hours in the schedule.
     */
    public Integer slotDurationInHours() {
        return slotDurationInHours;
    }

    /**
     * <p>
     * The end date for the Scheduled Instance.
     * </p>
     * 
     * @return The end date for the Scheduled Instance.
     */
    public Instant termEndDate() {
        return termEndDate;
    }

    /**
     * <p>
     * The start date for the Scheduled Instance.
     * </p>
     * 
     * @return The start date for the Scheduled Instance.
     */
    public Instant termStartDate() {
        return termStartDate;
    }

    /**
     * <p>
     * The total number of hours for a single instance for the entire term.
     * </p>
     * 
     * @return The total number of hours for a single instance for the entire term.
     */
    public Integer totalScheduledInstanceHours() {
        return totalScheduledInstanceHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyPrice());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(networkPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(nextSlotStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(previousSlotEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(slotDurationInHours());
        hashCode = 31 * hashCode + Objects.hashCode(termEndDate());
        hashCode = 31 * hashCode + Objects.hashCode(termStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(totalScheduledInstanceHours());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledInstance)) {
            return false;
        }
        ScheduledInstance other = (ScheduledInstance) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(hourlyPrice(), other.hourlyPrice()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(networkPlatform(), other.networkPlatform())
                && Objects.equals(nextSlotStartTime(), other.nextSlotStartTime()) && Objects.equals(platform(), other.platform())
                && Objects.equals(previousSlotEndTime(), other.previousSlotEndTime())
                && Objects.equals(recurrence(), other.recurrence())
                && Objects.equals(scheduledInstanceId(), other.scheduledInstanceId())
                && Objects.equals(slotDurationInHours(), other.slotDurationInHours())
                && Objects.equals(termEndDate(), other.termEndDate()) && Objects.equals(termStartDate(), other.termStartDate())
                && Objects.equals(totalScheduledInstanceHours(), other.totalScheduledInstanceHours());
    }

    @Override
    public String toString() {
        return ToString.builder("ScheduledInstance").add("AvailabilityZone", availabilityZone()).add("CreateDate", createDate())
                .add("HourlyPrice", hourlyPrice()).add("InstanceCount", instanceCount()).add("InstanceType", instanceType())
                .add("NetworkPlatform", networkPlatform()).add("NextSlotStartTime", nextSlotStartTime())
                .add("Platform", platform()).add("PreviousSlotEndTime", previousSlotEndTime()).add("Recurrence", recurrence())
                .add("ScheduledInstanceId", scheduledInstanceId()).add("SlotDurationInHours", slotDurationInHours())
                .add("TermEndDate", termEndDate()).add("TermStartDate", termStartDate())
                .add("TotalScheduledInstanceHours", totalScheduledInstanceHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailabilityZone":
            return Optional.of(clazz.cast(availabilityZone()));
        case "CreateDate":
            return Optional.of(clazz.cast(createDate()));
        case "HourlyPrice":
            return Optional.of(clazz.cast(hourlyPrice()));
        case "InstanceCount":
            return Optional.of(clazz.cast(instanceCount()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "NetworkPlatform":
            return Optional.of(clazz.cast(networkPlatform()));
        case "NextSlotStartTime":
            return Optional.of(clazz.cast(nextSlotStartTime()));
        case "Platform":
            return Optional.of(clazz.cast(platform()));
        case "PreviousSlotEndTime":
            return Optional.of(clazz.cast(previousSlotEndTime()));
        case "Recurrence":
            return Optional.of(clazz.cast(recurrence()));
        case "ScheduledInstanceId":
            return Optional.of(clazz.cast(scheduledInstanceId()));
        case "SlotDurationInHours":
            return Optional.of(clazz.cast(slotDurationInHours()));
        case "TermEndDate":
            return Optional.of(clazz.cast(termEndDate()));
        case "TermStartDate":
            return Optional.of(clazz.cast(termStartDate()));
        case "TotalScheduledInstanceHours":
            return Optional.of(clazz.cast(totalScheduledInstanceHours()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, ScheduledInstance> {
        /**
         * <p>
         * The Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The date when the Scheduled Instance was purchased.
         * </p>
         * 
         * @param createDate
         *        The date when the Scheduled Instance was purchased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The hourly price for a single instance.
         * </p>
         * 
         * @param hourlyPrice
         *        The hourly price for a single instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyPrice(String hourlyPrice);

        /**
         * <p>
         * The number of instances.
         * </p>
         * 
         * @param instanceCount
         *        The number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * </p>
         * 
         * @param networkPlatform
         *        The network platform (<code>EC2-Classic</code> or <code>EC2-VPC</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPlatform(String networkPlatform);

        /**
         * <p>
         * The time for the next schedule to start.
         * </p>
         * 
         * @param nextSlotStartTime
         *        The time for the next schedule to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSlotStartTime(Instant nextSlotStartTime);

        /**
         * <p>
         * The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * </p>
         * 
         * @param platform
         *        The platform (<code>Linux/UNIX</code> or <code>Windows</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The time that the previous schedule ended or will end.
         * </p>
         * 
         * @param previousSlotEndTime
         *        The time that the previous schedule ended or will end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousSlotEndTime(Instant previousSlotEndTime);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * 
         * @param recurrence
         *        The schedule recurrence.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(ScheduledInstanceRecurrence recurrence);

        /**
         * <p>
         * The schedule recurrence.
         * </p>
         * This is a convenience that creates an instance of the {@link ScheduledInstanceRecurrence.Builder} avoiding
         * the need to create one manually via {@link ScheduledInstanceRecurrence#builder()}.
         *
         * When the {@link Consumer} completes, {@link ScheduledInstanceRecurrence.Builder#build()} is called
         * immediately and its result is passed to {@link #recurrence(ScheduledInstanceRecurrence)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link ScheduledInstanceRecurrence.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(ScheduledInstanceRecurrence)
         */
        default Builder recurrence(Consumer<ScheduledInstanceRecurrence.Builder> recurrence) {
            return recurrence(ScheduledInstanceRecurrence.builder().apply(recurrence).build());
        }

        /**
         * <p>
         * The Scheduled Instance ID.
         * </p>
         * 
         * @param scheduledInstanceId
         *        The Scheduled Instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledInstanceId(String scheduledInstanceId);

        /**
         * <p>
         * The number of hours in the schedule.
         * </p>
         * 
         * @param slotDurationInHours
         *        The number of hours in the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotDurationInHours(Integer slotDurationInHours);

        /**
         * <p>
         * The end date for the Scheduled Instance.
         * </p>
         * 
         * @param termEndDate
         *        The end date for the Scheduled Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termEndDate(Instant termEndDate);

        /**
         * <p>
         * The start date for the Scheduled Instance.
         * </p>
         * 
         * @param termStartDate
         *        The start date for the Scheduled Instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termStartDate(Instant termStartDate);

        /**
         * <p>
         * The total number of hours for a single instance for the entire term.
         * </p>
         * 
         * @param totalScheduledInstanceHours
         *        The total number of hours for a single instance for the entire term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private Instant createDate;

        private String hourlyPrice;

        private Integer instanceCount;

        private String instanceType;

        private String networkPlatform;

        private Instant nextSlotStartTime;

        private String platform;

        private Instant previousSlotEndTime;

        private ScheduledInstanceRecurrence recurrence;

        private String scheduledInstanceId;

        private Integer slotDurationInHours;

        private Instant termEndDate;

        private Instant termStartDate;

        private Integer totalScheduledInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledInstance model) {
            availabilityZone(model.availabilityZone);
            createDate(model.createDate);
            hourlyPrice(model.hourlyPrice);
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            networkPlatform(model.networkPlatform);
            nextSlotStartTime(model.nextSlotStartTime);
            platform(model.platform);
            previousSlotEndTime(model.previousSlotEndTime);
            recurrence(model.recurrence);
            scheduledInstanceId(model.scheduledInstanceId);
            slotDurationInHours(model.slotDurationInHours);
            termEndDate(model.termEndDate);
            termStartDate(model.termStartDate);
            totalScheduledInstanceHours(model.totalScheduledInstanceHours);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getHourlyPrice() {
            return hourlyPrice;
        }

        @Override
        public final Builder hourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
            return this;
        }

        public final void setHourlyPrice(String hourlyPrice) {
            this.hourlyPrice = hourlyPrice;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getNetworkPlatform() {
            return networkPlatform;
        }

        @Override
        public final Builder networkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
            return this;
        }

        public final void setNetworkPlatform(String networkPlatform) {
            this.networkPlatform = networkPlatform;
        }

        public final Instant getNextSlotStartTime() {
            return nextSlotStartTime;
        }

        @Override
        public final Builder nextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
            return this;
        }

        public final void setNextSlotStartTime(Instant nextSlotStartTime) {
            this.nextSlotStartTime = nextSlotStartTime;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Instant getPreviousSlotEndTime() {
            return previousSlotEndTime;
        }

        @Override
        public final Builder previousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
            return this;
        }

        public final void setPreviousSlotEndTime(Instant previousSlotEndTime) {
            this.previousSlotEndTime = previousSlotEndTime;
        }

        public final ScheduledInstanceRecurrence.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        @Override
        public final Builder recurrence(ScheduledInstanceRecurrence recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(ScheduledInstanceRecurrence.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        public final String getScheduledInstanceId() {
            return scheduledInstanceId;
        }

        @Override
        public final Builder scheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
            return this;
        }

        public final void setScheduledInstanceId(String scheduledInstanceId) {
            this.scheduledInstanceId = scheduledInstanceId;
        }

        public final Integer getSlotDurationInHours() {
            return slotDurationInHours;
        }

        @Override
        public final Builder slotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
            return this;
        }

        public final void setSlotDurationInHours(Integer slotDurationInHours) {
            this.slotDurationInHours = slotDurationInHours;
        }

        public final Instant getTermEndDate() {
            return termEndDate;
        }

        @Override
        public final Builder termEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
            return this;
        }

        public final void setTermEndDate(Instant termEndDate) {
            this.termEndDate = termEndDate;
        }

        public final Instant getTermStartDate() {
            return termStartDate;
        }

        @Override
        public final Builder termStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
            return this;
        }

        public final void setTermStartDate(Instant termStartDate) {
            this.termStartDate = termStartDate;
        }

        public final Integer getTotalScheduledInstanceHours() {
            return totalScheduledInstanceHours;
        }

        @Override
        public final Builder totalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
            return this;
        }

        public final void setTotalScheduledInstanceHours(Integer totalScheduledInstanceHours) {
            this.totalScheduledInstanceHours = totalScheduledInstanceHours;
        }

        @Override
        public ScheduledInstance build() {
            return new ScheduledInstance(this);
        }
    }
}
