/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the data feed for a Spot instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SpotDatafeedSubscription implements ToCopyableBuilder<SpotDatafeedSubscription.Builder, SpotDatafeedSubscription> {
    private final String bucket;

    private final SpotInstanceStateFault fault;

    private final String ownerId;

    private final String prefix;

    private final String state;

    private SpotDatafeedSubscription(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.fault = builder.fault;
        this.ownerId = builder.ownerId;
        this.prefix = builder.prefix;
        this.state = builder.state;
    }

    /**
     * <p>
     * The Amazon S3 bucket where the Spot instance data feed is located.
     * </p>
     * 
     * @return The Amazon S3 bucket where the Spot instance data feed is located.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The fault codes for the Spot instance request, if any.
     * </p>
     * 
     * @return The fault codes for the Spot instance request, if any.
     */
    public SpotInstanceStateFault fault() {
        return fault;
    }

    /**
     * <p>
     * The AWS account ID of the account.
     * </p>
     * 
     * @return The AWS account ID of the account.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The prefix that is prepended to data feed files.
     * </p>
     * 
     * @return The prefix that is prepended to data feed files.
     */
    public String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The state of the Spot instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public DatafeedSubscriptionState state() {
        return DatafeedSubscriptionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the Spot instance data feed subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link DatafeedSubscriptionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the Spot instance data feed subscription.
     * @see DatafeedSubscriptionState
     */
    public String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(fault());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotDatafeedSubscription)) {
            return false;
        }
        SpotDatafeedSubscription other = (SpotDatafeedSubscription) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(fault(), other.fault())
                && Objects.equals(ownerId(), other.ownerId()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("SpotDatafeedSubscription").add("Bucket", bucket()).add("Fault", fault())
                .add("OwnerId", ownerId()).add("Prefix", prefix()).add("State", stateAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.of(clazz.cast(bucket()));
        case "Fault":
            return Optional.of(clazz.cast(fault()));
        case "OwnerId":
            return Optional.of(clazz.cast(ownerId()));
        case "Prefix":
            return Optional.of(clazz.cast(prefix()));
        case "State":
            return Optional.of(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, SpotDatafeedSubscription> {
        /**
         * <p>
         * The Amazon S3 bucket where the Spot instance data feed is located.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket where the Spot instance data feed is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The fault codes for the Spot instance request, if any.
         * </p>
         * 
         * @param fault
         *        The fault codes for the Spot instance request, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fault(SpotInstanceStateFault fault);

        /**
         * <p>
         * The fault codes for the Spot instance request, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link SpotInstanceStateFault.Builder} avoiding the
         * need to create one manually via {@link SpotInstanceStateFault#builder()}.
         *
         * When the {@link Consumer} completes, {@link SpotInstanceStateFault.Builder#build()} is called immediately and
         * its result is passed to {@link #fault(SpotInstanceStateFault)}.
         * 
         * @param fault
         *        a consumer that will call methods on {@link SpotInstanceStateFault.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fault(SpotInstanceStateFault)
         */
        default Builder fault(Consumer<SpotInstanceStateFault.Builder> fault) {
            return fault(SpotInstanceStateFault.builder().apply(fault).build());
        }

        /**
         * <p>
         * The AWS account ID of the account.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The prefix that is prepended to data feed files.
         * </p>
         * 
         * @param prefix
         *        The prefix that is prepended to data feed files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The state of the Spot instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Spot instance data feed subscription.
         * </p>
         * 
         * @param state
         *        The state of the Spot instance data feed subscription.
         * @see DatafeedSubscriptionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatafeedSubscriptionState
         */
        Builder state(DatafeedSubscriptionState state);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private SpotInstanceStateFault fault;

        private String ownerId;

        private String prefix;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotDatafeedSubscription model) {
            bucket(model.bucket);
            fault(model.fault);
            ownerId(model.ownerId);
            prefix(model.prefix);
            state(model.state);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final SpotInstanceStateFault.Builder getFault() {
            return fault != null ? fault.toBuilder() : null;
        }

        @Override
        public final Builder fault(SpotInstanceStateFault fault) {
            this.fault = fault;
            return this;
        }

        public final void setFault(SpotInstanceStateFault.BuilderImpl fault) {
            this.fault = fault != null ? fault.build() : null;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DatafeedSubscriptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public SpotDatafeedSubscription build() {
            return new SpotDatafeedSubscription(this);
        }
    }
}
