/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of StopInstances.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class StopInstancesResponse extends EC2Response implements
        ToCopyableBuilder<StopInstancesResponse.Builder, StopInstancesResponse> {
    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.stoppingInstances = builder.stoppingInstances;
    }

    /**
     * <p>
     * Information about one or more stopped instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more stopped instances.
     */
    public List<InstanceStateChange> stoppingInstances() {
        return stoppingInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stoppingInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse) obj;
        return Objects.equals(stoppingInstances(), other.stoppingInstances());
    }

    @Override
    public String toString() {
        return ToString.builder("StopInstancesResponse").add("StoppingInstances", stoppingInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StoppingInstances":
            return Optional.of(clazz.cast(stoppingInstances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends EC2Response.Builder, CopyableBuilder<Builder, StopInstancesResponse> {
        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances);

        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * 
         * @param stoppingInstances
         *        Information about one or more stopped instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingInstances(InstanceStateChange... stoppingInstances);

        /**
         * <p>
         * Information about one or more stopped instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceStateChange>.Builder} avoiding the
         * need to create one manually via {@link List<InstanceStateChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceStateChange>.Builder#build()} is called immediately
         * and its result is passed to {@link #stoppingInstances(List<InstanceStateChange>)}.
         * 
         * @param stoppingInstances
         *        a consumer that will call methods on {@link List<InstanceStateChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingInstances(List<InstanceStateChange>)
         */
        Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances);
    }

    static final class BuilderImpl extends EC2Response.BuilderImpl implements Builder {
        private List<InstanceStateChange> stoppingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            super(model);
            stoppingInstances(model.stoppingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStoppingInstances() {
            return stoppingInstances != null ? stoppingInstances.stream().map(InstanceStateChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange... stoppingInstances) {
            stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(Consumer<InstanceStateChange.Builder>... stoppingInstances) {
            stoppingInstances(Stream.of(stoppingInstances).map(c -> InstanceStateChange.builder().apply(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }
    }
}
