/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeDetail implements ToCopyableBuilder<VolumeDetail.Builder, VolumeDetail> {
    private final Long size;

    private VolumeDetail(BuilderImpl builder) {
        this.size = builder.size;
    }

    /**
     * <p>
     * The size of the volume, in GiB.
     * </p>
     * 
     * @return The size of the volume, in GiB.
     */
    public Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(size());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeDetail)) {
            return false;
        }
        VolumeDetail other = (VolumeDetail) obj;
        return Objects.equals(size(), other.size());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeDetail").add("Size", size()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Size":
            return Optional.of(clazz.cast(size()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeDetail> {
        /**
         * <p>
         * The size of the volume, in GiB.
         * </p>
         * 
         * @param size
         *        The size of the volume, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    static final class BuilderImpl implements Builder {
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeDetail model) {
            size(model.size);
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public VolumeDetail build() {
            return new VolumeDetail(this);
        }
    }
}
