/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a volume status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class VolumeStatusDetails implements ToCopyableBuilder<VolumeStatusDetails.Builder, VolumeStatusDetails> {
    private final String name;

    private final String status;

    private VolumeStatusDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the volume status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link VolumeStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the volume status.
     * @see VolumeStatusName
     */
    public VolumeStatusName name() {
        return VolumeStatusName.fromValue(name);
    }

    /**
     * <p>
     * The name of the volume status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link VolumeStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the volume status.
     * @see VolumeStatusName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The intended status of the volume status.
     * </p>
     * 
     * @return The intended status of the volume status.
     */
    public String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusDetails)) {
            return false;
        }
        VolumeStatusDetails other = (VolumeStatusDetails) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(status(), other.status());
    }

    @Override
    public String toString() {
        return ToString.builder("VolumeStatusDetails").add("Name", nameAsString()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(nameAsString()));
        case "Status":
            return Optional.of(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, VolumeStatusDetails> {
        /**
         * <p>
         * The name of the volume status.
         * </p>
         * 
         * @param name
         *        The name of the volume status.
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the volume status.
         * </p>
         * 
         * @param name
         *        The name of the volume status.
         * @see VolumeStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeStatusName
         */
        Builder name(VolumeStatusName name);

        /**
         * <p>
         * The intended status of the volume status.
         * </p>
         * 
         * @param status
         *        The intended status of the volume status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusDetails model) {
            name(model.name);
            status(model.status);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(VolumeStatusName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public VolumeStatusDetails build() {
            return new VolumeStatusDetails(this);
        }
    }
}
