/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Vpc implements ToCopyableBuilder<Vpc.Builder, Vpc> {
    private final String cidrBlock;

    private final String dhcpOptionsId;

    private final String state;

    private final String vpcId;

    private final String instanceTenancy;

    private final List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

    private final List<VpcCidrBlockAssociation> cidrBlockAssociationSet;

    private final Boolean isDefault;

    private final List<Tag> tags;

    private Vpc(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
        this.vpcId = builder.vpcId;
        this.instanceTenancy = builder.instanceTenancy;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.isDefault = builder.isDefault;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The primary IPv4 CIDR block for the VPC.
     * </p>
     * 
     * @return The primary IPv4 CIDR block for the VPC.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default options
     * are associated with the VPC).
     * </p>
     * 
     * @return The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default
     *         options are associated with the VPC).
     */
    public String dhcpOptionsId() {
        return dhcpOptionsId;
    }

    /**
     * <p>
     * The current state of the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the VPC.
     * @see VpcState
     */
    public VpcState state() {
        return VpcState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link VpcState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the VPC.
     * @see VpcState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The allowed tenancy of instances launched into the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The allowed tenancy of instances launched into the VPC.
     * @see Tenancy
     */
    public Tenancy instanceTenancy() {
        return Tenancy.fromValue(instanceTenancy);
    }

    /**
     * <p>
     * The allowed tenancy of instances launched into the VPC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceTenancy}
     * will return {@link Tenancy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTenancyAsString}.
     * </p>
     * 
     * @return The allowed tenancy of instances launched into the VPC.
     * @see Tenancy
     */
    public String instanceTenancyAsString() {
        return instanceTenancy;
    }

    /**
     * <p>
     * Information about the IPv6 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv6 CIDR blocks associated with the VPC.
     */
    public List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return ipv6CidrBlockAssociationSet;
    }

    /**
     * <p>
     * Information about the IPv4 CIDR blocks associated with the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the IPv4 CIDR blocks associated with the VPC.
     */
    public List<VpcCidrBlockAssociation> cidrBlockAssociationSet() {
        return cidrBlockAssociationSet;
    }

    /**
     * <p>
     * Indicates whether the VPC is the default VPC.
     * </p>
     * 
     * @return Indicates whether the VPC is the default VPC.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * Any tags assigned to the VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the VPC.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6CidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(cidrBlockAssociationSet());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc) obj;
        return Objects.equals(cidrBlock(), other.cidrBlock()) && Objects.equals(dhcpOptionsId(), other.dhcpOptionsId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(instanceTenancyAsString(), other.instanceTenancyAsString())
                && Objects.equals(ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet())
                && Objects.equals(cidrBlockAssociationSet(), other.cidrBlockAssociationSet())
                && Objects.equals(isDefault(), other.isDefault()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("Vpc").add("CidrBlock", cidrBlock()).add("DhcpOptionsId", dhcpOptionsId())
                .add("State", stateAsString()).add("VpcId", vpcId()).add("InstanceTenancy", instanceTenancyAsString())
                .add("Ipv6CidrBlockAssociationSet", ipv6CidrBlockAssociationSet())
                .add("CidrBlockAssociationSet", cidrBlockAssociationSet()).add("IsDefault", isDefault()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrBlock":
            return Optional.of(clazz.cast(cidrBlock()));
        case "DhcpOptionsId":
            return Optional.of(clazz.cast(dhcpOptionsId()));
        case "State":
            return Optional.of(clazz.cast(stateAsString()));
        case "VpcId":
            return Optional.of(clazz.cast(vpcId()));
        case "InstanceTenancy":
            return Optional.of(clazz.cast(instanceTenancyAsString()));
        case "Ipv6CidrBlockAssociationSet":
            return Optional.of(clazz.cast(ipv6CidrBlockAssociationSet()));
        case "CidrBlockAssociationSet":
            return Optional.of(clazz.cast(cidrBlockAssociationSet()));
        case "IsDefault":
            return Optional.of(clazz.cast(isDefault()));
        case "Tags":
            return Optional.of(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Vpc> {
        /**
         * <p>
         * The primary IPv4 CIDR block for the VPC.
         * </p>
         * 
         * @param cidrBlock
         *        The primary IPv4 CIDR block for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the default
         * options are associated with the VPC).
         * </p>
         * 
         * @param dhcpOptionsId
         *        The ID of the set of DHCP options you've associated with the VPC (or <code>default</code> if the
         *        default options are associated with the VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpOptionsId(String dhcpOptionsId);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the VPC.
         * </p>
         * 
         * @param state
         *        The current state of the VPC.
         * @see VpcState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpcState
         */
        Builder state(VpcState state);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(String instanceTenancy);

        /**
         * <p>
         * The allowed tenancy of instances launched into the VPC.
         * </p>
         * 
         * @param instanceTenancy
         *        The allowed tenancy of instances launched into the VPC.
         * @see Tenancy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tenancy
         */
        Builder instanceTenancy(Tenancy instanceTenancy);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param ipv6CidrBlockAssociationSet
         *        Information about the IPv6 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv6 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcIpv6CidrBlockAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<VpcIpv6CidrBlockAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcIpv6CidrBlockAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #ipv6CidrBlockAssociationSet(List<VpcIpv6CidrBlockAssociation>)}.
         * 
         * @param ipv6CidrBlockAssociationSet
         *        a consumer that will call methods on {@link List<VpcIpv6CidrBlockAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6CidrBlockAssociationSet(List<VpcIpv6CidrBlockAssociation>)
         */
        Builder ipv6CidrBlockAssociationSet(Consumer<VpcIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * 
         * @param cidrBlockAssociationSet
         *        Information about the IPv4 CIDR blocks associated with the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlockAssociationSet(VpcCidrBlockAssociation... cidrBlockAssociationSet);

        /**
         * <p>
         * Information about the IPv4 CIDR blocks associated with the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VpcCidrBlockAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<VpcCidrBlockAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VpcCidrBlockAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #cidrBlockAssociationSet(List<VpcCidrBlockAssociation>)}.
         * 
         * @param cidrBlockAssociationSet
         *        a consumer that will call methods on {@link List<VpcCidrBlockAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cidrBlockAssociationSet(List<VpcCidrBlockAssociation>)
         */
        Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder>... cidrBlockAssociationSet);

        /**
         * <p>
         * Indicates whether the VPC is the default VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether the VPC is the default VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags assigned to the VPC.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String cidrBlock;

        private String dhcpOptionsId;

        private String state;

        private String vpcId;

        private String instanceTenancy;

        private List<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;

        private List<VpcCidrBlockAssociation> cidrBlockAssociationSet;

        private Boolean isDefault;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Vpc model) {
            cidrBlock(model.cidrBlock);
            dhcpOptionsId(model.dhcpOptionsId);
            state(model.state);
            vpcId(model.vpcId);
            instanceTenancy(model.instanceTenancy);
            ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            isDefault(model.isDefault);
            tags(model.tags);
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getDhcpOptionsId() {
            return dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpcState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getInstanceTenancy() {
            return instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final Collection<VpcIpv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            return ipv6CidrBlockAssociationSet != null ? ipv6CidrBlockAssociationSet.stream()
                    .map(VpcIpv6CidrBlockAssociation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(
                Consumer<VpcIpv6CidrBlockAssociation.Builder>... ipv6CidrBlockAssociationSet) {
            ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet)
                    .map(c -> VpcIpv6CidrBlockAssociation.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrBlockAssociationSet(
                Collection<VpcIpv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = VpcIpv6CidrBlockAssociationSetCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        public final Collection<VpcCidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            return cidrBlockAssociationSet != null ? cidrBlockAssociationSet.stream().map(VpcCidrBlockAssociation::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(VpcCidrBlockAssociation... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<VpcCidrBlockAssociation.Builder>... cidrBlockAssociationSet) {
            cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet)
                    .map(c -> VpcCidrBlockAssociation.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = VpcCidrBlockAssociationSetCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().apply(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Vpc build() {
            return new Vpc(this);
        }
    }
}
