/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * AssociateVpcCidrBlockRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class AssociateVpcCidrBlockRequestMarshaller implements
        Marshaller<Request<AssociateVpcCidrBlockRequest>, AssociateVpcCidrBlockRequest> {

    public Request<AssociateVpcCidrBlockRequest> marshall(AssociateVpcCidrBlockRequest associateVpcCidrBlockRequest) {

        if (associateVpcCidrBlockRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<AssociateVpcCidrBlockRequest> request = new DefaultRequest<AssociateVpcCidrBlockRequest>(
                associateVpcCidrBlockRequest, "EC2Client");
        request.addParameter("Action", "AssociateVpcCidrBlock");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (associateVpcCidrBlockRequest.amazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock",
                    StringUtils.fromBoolean(associateVpcCidrBlockRequest.amazonProvidedIpv6CidrBlock()));
        }

        if (associateVpcCidrBlockRequest.cidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(associateVpcCidrBlockRequest.cidrBlock()));
        }

        if (associateVpcCidrBlockRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(associateVpcCidrBlockRequest.vpcId()));
        }

        return request;
    }

}
