/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateDhcpOptionsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateDhcpOptionsRequestMarshaller implements
        Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {

    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {

        if (createDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateDhcpOptionsRequest> request = new DefaultRequest<CreateDhcpOptionsRequest>(createDhcpOptionsRequest,
                "EC2Client");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<DhcpConfiguration> createDhcpOptionsRequestDhcpConfigurationsList = createDhcpOptionsRequest
                .dhcpConfigurations();
        if (createDhcpOptionsRequestDhcpConfigurationsList != null) {
            int dhcpConfigurationsListIndex = 1;

            for (DhcpConfiguration createDhcpOptionsRequestDhcpConfigurationsListValue : createDhcpOptionsRequestDhcpConfigurationsList) {

                if (createDhcpOptionsRequestDhcpConfigurationsListValue.key() != null) {
                    request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Key",
                            StringUtils.fromString(createDhcpOptionsRequestDhcpConfigurationsListValue.key()));
                }

                java.util.List<String> dhcpConfigurationValuesList = createDhcpOptionsRequestDhcpConfigurationsListValue.values();
                if (dhcpConfigurationValuesList != null) {
                    int valuesListIndex = 1;

                    for (String dhcpConfigurationValuesListValue : dhcpConfigurationValuesList) {
                        if (dhcpConfigurationValuesListValue != null) {
                            request.addParameter(
                                    "DhcpConfiguration." + dhcpConfigurationsListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(dhcpConfigurationValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                dhcpConfigurationsListIndex++;
            }
        }

        return request;
    }

}
