/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateNetworkInterfacePermissionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateNetworkInterfacePermissionRequestMarshaller implements
        Marshaller<Request<CreateNetworkInterfacePermissionRequest>, CreateNetworkInterfacePermissionRequest> {

    public Request<CreateNetworkInterfacePermissionRequest> marshall(
            CreateNetworkInterfacePermissionRequest createNetworkInterfacePermissionRequest) {

        if (createNetworkInterfacePermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateNetworkInterfacePermissionRequest> request = new DefaultRequest<CreateNetworkInterfacePermissionRequest>(
                createNetworkInterfacePermissionRequest, "EC2Client");
        request.addParameter("Action", "CreateNetworkInterfacePermission");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (createNetworkInterfacePermissionRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId",
                    StringUtils.fromString(createNetworkInterfacePermissionRequest.networkInterfaceId()));
        }

        if (createNetworkInterfacePermissionRequest.awsAccountId() != null) {
            request.addParameter("AwsAccountId", StringUtils.fromString(createNetworkInterfacePermissionRequest.awsAccountId()));
        }

        if (createNetworkInterfacePermissionRequest.awsService() != null) {
            request.addParameter("AwsService", StringUtils.fromString(createNetworkInterfacePermissionRequest.awsService()));
        }

        if (createNetworkInterfacePermissionRequest.permissionAsString() != null) {
            request.addParameter("Permission",
                    StringUtils.fromString(createNetworkInterfacePermissionRequest.permissionAsString()));
        }

        return request;
    }

}
