/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * DescribeDhcpOptionsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeDhcpOptionsResponseUnmarshaller implements
        Unmarshaller<DescribeDhcpOptionsResponse, StaxUnmarshallerContext> {

    public DescribeDhcpOptionsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeDhcpOptionsResponse.Builder describeDhcpOptionsResponse = DescribeDhcpOptionsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<DhcpOptions> dhcpOptions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                describeDhcpOptionsResponse.dhcpOptions(dhcpOptions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("dhcpOptionsSet", targetDepth)) {
                    dhcpOptions = new ArrayList<DhcpOptions>();
                    continue;
                }

                if (context.testExpression("dhcpOptionsSet/item", targetDepth)) {
                    dhcpOptions.add(DhcpOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    describeDhcpOptionsResponse.dhcpOptions(dhcpOptions);
                    break;
                }
            }
        }
        return describeDhcpOptionsResponse.build();
    }

    private static final DescribeDhcpOptionsResponseUnmarshaller INSTANCE = new DescribeDhcpOptionsResponseUnmarshaller();

    public static DescribeDhcpOptionsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
