/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.ec2.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;

/**
 * DescribeSecurityGroupsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeSecurityGroupsRequestMarshaller implements
        Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {

    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {

        if (describeSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeSecurityGroupsRequest> request = new DefaultRequest<DescribeSecurityGroupsRequest>(
                describeSecurityGroupsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Filter> describeSecurityGroupsRequestFiltersList = describeSecurityGroupsRequest.filters();
        if (describeSecurityGroupsRequestFiltersList != null) {
            int filtersListIndex = 1;

            for (Filter describeSecurityGroupsRequestFiltersListValue : describeSecurityGroupsRequestFiltersList) {

                if (describeSecurityGroupsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name",
                            StringUtils.fromString(describeSecurityGroupsRequestFiltersListValue.name()));
                }

                java.util.List<String> filterValuesList = describeSecurityGroupsRequestFiltersListValue.values();
                if (filterValuesList != null) {
                    int valuesListIndex = 1;

                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex,
                                    StringUtils.fromString(filterValuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        java.util.List<String> describeSecurityGroupsRequestGroupIdsList = describeSecurityGroupsRequest.groupIds();
        if (describeSecurityGroupsRequestGroupIdsList != null) {
            int groupIdsListIndex = 1;

            for (String describeSecurityGroupsRequestGroupIdsListValue : describeSecurityGroupsRequestGroupIdsList) {
                if (describeSecurityGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex,
                            StringUtils.fromString(describeSecurityGroupsRequestGroupIdsListValue));
                }
                groupIdsListIndex++;
            }
        }

        java.util.List<String> describeSecurityGroupsRequestGroupNamesList = describeSecurityGroupsRequest.groupNames();
        if (describeSecurityGroupsRequestGroupNamesList != null) {
            int groupNamesListIndex = 1;

            for (String describeSecurityGroupsRequestGroupNamesListValue : describeSecurityGroupsRequestGroupNamesList) {
                if (describeSecurityGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex,
                            StringUtils.fromString(describeSecurityGroupsRequestGroupNamesListValue));
                }
                groupNamesListIndex++;
            }
        }

        if (describeSecurityGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeSecurityGroupsRequest.nextToken()));
        }

        if (describeSecurityGroupsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeSecurityGroupsRequest.maxResults()));
        }

        return request;
    }

}
